/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.Logger;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.clover.cfg.instr.InstrumentationLevel;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.StatementRegexpContext;
import com.atlassian.clover.util.FilterUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.RegexpEntry;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.eclipse.core.settings.Settings;
import org.openclover.util.Sets;

public class ProjectSettings
extends Settings {
    public static final String DEFAULT_INCLUDE_PATTERN = "**/*.java";
    public static final String DEFAULT_TEST_INCLUDE_PATTERN = "**/*Test.java,**/Test*.java";
    public static final String DEFAULT_EXCLUDE_PATTERN = "";
    private static final Set<String> CONTAINER_NATURES = Sets.newHashSet("org.eclipse.wst.common.project.facet.core.nature");
    private static final ListMarshaller<RegexpEntry> REGEXP_CONTEXT_MARSHALLER = new RegexpFilterMarshaller();
    private static final ListMarshaller<String> STRING_LIST_MARSHALLER = new StringListMarshaller();
    private static final ListMarshaller<SourceFolderPattern> FOLDER_LIST_MARSHALLER = new FolderListMarshaller();
    protected IProject project;
    private IScopeContext[] scopeContext;

    public ProjectSettings(IProject project) {
        this.project = project;
        this.isolatedPreferences = (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node("project").node(project.getName()).node("org.openclover.eclipse.core");
    }

    @Override
    protected IScopeContext[] getScopeDelegation() {
        if (this.scopeContext == null) {
            this.scopeContext = new IScopeContext[]{new ProjectScope(this.project.getProject())};
        }
        return this.scopeContext;
    }

    public IProject getProject() {
        return this.project.getProject();
    }

    public boolean isInstrumentationEnabled() {
        return this.getBoolean("instrumentation_enabled");
    }

    public void setInstrumentationEnabled(boolean enabled) {
        this.setValue("instrumentation_enabled", enabled);
    }

    public void updateOutputRoot(boolean sameAsProject, String path, boolean recreateOutputDirs) {
        this.setValue("output_root_same_as_project", sameAsProject);
        this.setValue("output_root", path);
        this.setValue("recreate_output_dirs", recreateOutputDirs);
    }

    public boolean isOutputRootSameAsProject() {
        return this.getBoolean("output_root_same_as_project");
    }

    public String getOutputRoot() {
        return this.getString("output_root");
    }

    public boolean isRecreateOutputDirs() {
        return this.getBoolean("recreate_output_dirs");
    }

    public boolean isInitStringDefault() {
        return this.getBoolean("init_string_default");
    }

    public String getInitString() {
        return this.getString("init_string");
    }

    public boolean isInitStringProjectRelative() {
        return this.getBoolean("init_string_project_relative");
    }

    public void updateInitString(boolean useDefault, String initString, boolean projectRelative) {
        this.setValue("init_string_default", useDefault);
        this.setValue("init_string", initString);
        this.setValue("init_string_project_relative", projectRelative);
    }

    public int getFlushPolicy() {
        int policy = this.getInt("flush_policy", -1);
        if (-1 == policy) {
            policy = this.mightBeContainedProject(this.project) ? 2 : 0;
        }
        return policy;
    }

    public void updateFlushPolicy(int flushPolicy, int flushInterval) {
        this.setValue("flush_policy", flushPolicy);
        this.setValue("flush_interval", flushInterval);
    }

    public int getFlushInterval() {
        return this.getInt("flush_interval");
    }

    private boolean mightBeContainedProject(IProject project) {
        IProject[] referencingProjects;
        if (this.isContainerProject(project)) {
            return true;
        }
        for (IProject referencingProject : referencingProjects = project.getReferencingProjects()) {
            if (!this.isContainerProject(referencingProject)) continue;
            return true;
        }
        return false;
    }

    private boolean isContainerProject(IProject project) {
        for (String nature : CONTAINER_NATURES) {
            try {
                if (!project.hasNature(nature)) continue;
                return true;
            }
            catch (CoreException e) {
                Logger.getInstance().error(String.format("Failed to query project \"%s\" for nature \"%s\"", project, nature), e);
            }
        }
        return false;
    }

    public void setFlushInterval(int interval) {
        this.setValue("flush_interval", interval);
    }

    public Interval calcEffectiveSpanInterval(CloverDatabase database) {
        return new Interval(BigDecimal.valueOf(this.calcEffectiveSpanMS(database) / 1000L), 0);
    }

    public long calcEffectiveSpanMS(CloverDatabase database) {
        long userSpan = CloverPlugin.getInstance().getInstallationSettings().getCoverageSpan().getValueInMillis();
        if (CloverPlugin.getInstance().getInstallationSettings().isAggregatingCoverage()) {
            long now = System.currentTimeMillis();
            if (database != null) {
                return database.getRegistry().getVersion() - database.getRegistry().getFirstVersion() + userSpan;
            }
            long lastClean = CloverProject.getLastCleanBuildStamp(this.project);
            return (lastClean != 0L ? System.currentTimeMillis() - lastClean : 0L) + userSpan;
        }
        return userSpan;
    }

    public String getIncludeFilter() {
        return this.getString("include_filter");
    }

    public String getExcludeFilter() {
        return this.getString("exclude_filter");
    }

    public String[] calculateIncludeFilter() {
        String filter = this.getIncludeFilter();
        return FilterUtils.tokenizePattern(filter != null ? filter : DEFAULT_INCLUDE_PATTERN);
    }

    public String[] calculateExcludeFilter() {
        String filter = this.getExcludeFilter();
        return FilterUtils.tokenizePattern(filter != null ? filter : DEFAULT_EXCLUDE_PATTERN);
    }

    public ContextSet getContextFilter() {
        String blockFilterString = this.getString("block_filters");
        return blockFilterString == null ? new ContextSet() : this.getContextRegistry().createContextSetFilter(blockFilterString, false);
    }

    public void setContextFilter(ContextSet blockFilter) {
        this.setValue("block_filters", this.getContextRegistry().getContextsAsString(blockFilter));
    }

    public ContextStore getContextRegistry() {
        ContextStore reg = new ContextStore();
        List<RegexpEntry> filters = this.getRegexpFilters();
        for (RegexpEntry entry : filters) {
            try {
                if (entry.getType() == 0) {
                    reg.addMethodContext(new MethodRegexpContext(entry.getName(), Pattern.compile(entry.getRegexp())));
                    continue;
                }
                reg.addStatementContext(new StatementRegexpContext(entry.getName(), Pattern.compile(entry.getRegexp())));
            }
            catch (Exception e) {
                CloverPlugin.logError("Unable to load regex entry " + entry.getName(), e);
            }
        }
        return reg;
    }

    public void setIncludeFilter(String filter) {
        this.setValue("include_filter", filter);
    }

    public void setExcludeFilter(String filter) {
        this.setValue("exclude_filter", filter);
    }

    public boolean isInstrumentSelectedSourceFolders() {
        return this.getBoolean("instrument_selected_source_folders");
    }

    public void setInstrumentSelectedSourceFolders(boolean instrumentSelectedOnly) {
        this.setValue("instrument_selected_source_folders", instrumentSelectedOnly);
    }

    public List<SourceFolderPattern> getInstrumentedFolderPatterns() {
        return this.getListProperty("instrumented_source_folder_patterns", FOLDER_LIST_MARSHALLER);
    }

    public void setInstrumentedFolderPatterns(List<SourceFolderPattern> folderPatterns) {
        this.setListProperty("instrumented_source_folder_patterns", folderPatterns, FOLDER_LIST_MARSHALLER);
    }

    public List<RegexpEntry> getRegexpFilters() {
        return this.getListProperty("regexp_filters", REGEXP_CONTEXT_MARSHALLER);
    }

    public void setRegexpFilters(List<RegexpEntry> filters) {
        this.setListProperty("regexp_filters", filters, REGEXP_CONTEXT_MARSHALLER);
    }

    public boolean shouldQualifyJavaLang() {
        return this.getBoolean("should_qualify_java_lang");
    }

    public void shouldQualifyJavaLang(boolean shouldQualify) {
        this.setValue("should_qualify_java_lang", shouldQualify);
    }

    public boolean isUsingDefaultTestDetection() {
        return this.getBoolean("using_default_test_detection");
    }

    public void setIsUsingDefaultTestDetection(boolean using) {
        this.setValue("using_default_test_detection", using);
    }

    public int getTestSourceFolders() {
        return this.getInt("test_source_folders", 0);
    }

    public void setTestSourceFolders(int testFolders) {
        if (testFolders < 0 || testFolders > 2) {
            throw new IllegalArgumentException("Invalid Test Source Folder option: " + testFolders);
        }
        this.setValue("test_source_folders", testFolders);
    }

    public void setTestIncludeFilter(String filter) {
        this.setValue("test_include_filter", filter);
    }

    public void setTestExcludeFilter(String filter) {
        this.setValue("test_exclude_filter", filter);
    }

    public String getTestIncludeFilter() {
        return this.getString("test_include_filter");
    }

    public String getTestExcludeFilter() {
        return this.getString("test_exclude_filter");
    }

    public String[] calculateTestIncludeFilter() {
        String filter = this.getTestIncludeFilter();
        return FilterUtils.tokenizePattern(filter != null ? filter : DEFAULT_TEST_INCLUDE_PATTERN);
    }

    public String[] calculateTestExcludeFilter() {
        String filter = this.getTestExcludeFilter();
        return FilterUtils.tokenizePattern(filter != null ? filter : DEFAULT_EXCLUDE_PATTERN);
    }

    public List<String> getSelectedTestFolders() {
        return this.getListProperty("selected_test_source_folders", STRING_LIST_MARSHALLER);
    }

    public void setSelectedTestFolders(List<String> folders) {
        this.setListProperty("selected_test_source_folders", folders, STRING_LIST_MARSHALLER);
    }

    public void setInstrumentationLevel(InstrumentationLevel level) {
        this.setValue("instrumentation_level", level.name());
    }

    public InstrumentationLevel getInstrumentationLevel() {
        String levelAsString = this.getString("instrumentation_level");
        return levelAsString == null ? Defaults.INSTRUMENTATION_LEVEL : InstrumentationLevel.valueOf(levelAsString);
    }

    public LambdaInstrumentation getInstrumentLambda() {
        String lambdaAsString = this.getString("instrument_lambda");
        return lambdaAsString == null ? Defaults.INSTRUMENT_LAMBDA : LambdaInstrumentation.valueOf(lambdaAsString);
    }

    public void setInstrumentLambda(LambdaInstrumentation level) {
        this.setValue("instrument_lambda", level.name());
    }

    public void initialise() {
    }

    public void upgrade() {
        String[] keys;
        for (String key : keys = new String[]{"instrumentation_enabled", "output_root_same_as_project", "output_root", "init_string_default", "init_string", "init_string_project_relative", "flush_policy", "flush_interval", "include_filter", "exclude_filter", "block_filters", "should_qualify_java_lang", "using_default_test_detection", "test_source_folders", "selected_test_source_folders"}) {
            try {
                QualifiedName qualifiedName = new QualifiedName("org.openclover.eclipse.core", key);
                String value = this.project.getProject().getPersistentProperty(qualifiedName);
                if (value == null) continue;
                this.setValue(key, value);
                this.project.getProject().setPersistentProperty(qualifiedName, null);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to migrate project setting " + key, e);
            }
        }
        int i = 0;
        String value = null;
        do {
            String indexedKey = "regexp_filters[" + i + "]";
            QualifiedName qualifiedName = new QualifiedName("org.openclover.eclipse.core", indexedKey);
            try {
                value = this.project.getPersistentProperty(qualifiedName);
                if (value == null) continue;
                this.setValue(indexedKey, value);
                this.project.getProject().setPersistentProperty(qualifiedName, null);
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to migrate project setting " + indexedKey, e);
            }
        } while (value != null);
        this.save();
    }

    protected boolean isPropertySet(String key) {
        return this.getString(key) != null;
    }

    private <T> void setListProperty(String key, List<T> list, ListMarshaller<T> marshaller) {
        String indexedKey;
        String data;
        int i = 0;
        while ((data = this.getString(indexedKey = key + "[" + i + "]")) != null) {
            this.setValue(indexedKey, null);
            ++i;
        }
        i = 0;
        while (true) {
            indexedKey = key + "[" + i + "]";
            if (i == list.size()) break;
            String str = marshaller.marshall(list.get(i));
            CloverPlugin.logVerbose("Storing project property data:'" + str + "'", null);
            this.setValue(indexedKey, str);
            ++i;
        }
    }

    private <T> List<T> getListProperty(String key, ListMarshaller<T> marshaller) {
        String indexedKey;
        String data;
        ArrayList<T> property = new ArrayList<T>();
        int i = 0;
        while ((data = this.getString(indexedKey = key + "[" + i + "]")) != null && !data.equals(DEFAULT_EXCLUDE_PATTERN)) {
            T ctx = marshaller.unmarshall(data);
            CloverPlugin.logDebug("converted '" + data + "' to " + ctx, null);
            if (ctx != null) {
                property.add(ctx);
            }
            ++i;
        }
        return property;
    }

    private static class FolderListMarshaller
    implements ListMarshaller<SourceFolderPattern> {
        private FolderListMarshaller() {
        }

        @Override
        public SourceFolderPattern unmarshall(String data) {
            String[] strings = data.split("\n");
            return new SourceFolderPattern(strings.length > 0 ? strings[0] : ProjectSettings.DEFAULT_EXCLUDE_PATTERN, strings.length > 1 ? strings[1] : ProjectSettings.DEFAULT_INCLUDE_PATTERN, strings.length > 2 ? strings[2] : ProjectSettings.DEFAULT_EXCLUDE_PATTERN, strings.length > 3 && "enabled".equals(strings[3]));
        }

        @Override
        public String marshall(SourceFolderPattern sfp) {
            return sfp == null ? ProjectSettings.DEFAULT_EXCLUDE_PATTERN : sfp.getSrcPath() + '\n' + sfp.getIncludePattern() + '\n' + sfp.getExcludePattern() + '\n' + (sfp.isEnabled() ? "enabled" : "disabled");
        }
    }

    private static class StringListMarshaller
    implements ListMarshaller<String> {
        private StringListMarshaller() {
        }

        @Override
        public String unmarshall(String data) {
            return data;
        }

        @Override
        public String marshall(String object) {
            return object;
        }
    }

    private static class RegexpFilterMarshaller
    implements ListMarshaller<RegexpEntry> {
        private RegexpFilterMarshaller() {
        }

        @Override
        public RegexpEntry unmarshall(String data) {
            return new RegexpEntry(data);
        }

        @Override
        public String marshall(RegexpEntry object) {
            return object.toString();
        }
    }

    public static interface ListMarshaller<T> {
        public T unmarshall(String var1);

        public String marshall(T var1);
    }

    public static class Defaults {
        public static final int FLUSH_POLICY = 0;
        public static final int WEBAPP_FLUSH_POLICY = 2;
        public static final int FLUSH_INTERVAL = 1000;
        public static final String USER_OUTPUT_DIR = ".clover/bin";
        public static final boolean RECREATE_OUTPUT_DIRS = true;
        public static final String USER_INITSTRING = ".clover/coverage.db";
        public static final boolean OPEN_IN_BROWSER = true;
        public static final boolean SHOULD_QUALIFY_JAVA_LANG = true;
        public static final boolean USING_DEFAULT_TEST_DETECTION = true;
        public static final boolean OUTPUT_ROOT_SAME_AS_PROJECT = true;
        public static final int TEST_SOURCE_FOLDERS = 0;
        public static final InstrumentationLevel INSTRUMENTATION_LEVEL = InstrumentationLevel.STATEMENT;
        public static final LambdaInstrumentation INSTRUMENT_LAMBDA = LambdaInstrumentation.NONE;
    }

    public static class Values {
        public static final String DIRECTED_FLUSH_POLICY = "directed";
        public static final String INTERVAL_FLUSH_POLICY = "interval";
        public static final String THREADED_FLUSH_POLICY = "threaded";
        public static final String AUTOMATIC_INIT_STRING_TYPE = "automatic";
        public static final String USE_SPECIFIED_INIT_STRING_TYPE = "userspecified";
        public static final int ALL_FOLDERS = 0;
        public static final int SELECTED_FOLDERS = 1;
        public static final int NO_TEST_FOLDERS = 2;
    }

    public static class Keys {
        public static final String INSTRUMENTATION_ENABLED = "instrumentation_enabled";
        public static final String OUTPUT_ROOT_SAME_AS_PROJECT = "output_root_same_as_project";
        public static final String OUTPUT_ROOT = "output_root";
        public static final String INIT_STRING_DEFAULT = "init_string_default";
        public static final String INIT_STRING = "init_string";
        public static final String INIT_STRING_PROJECT_RELATIVE = "init_string_project_relative";
        public static final String FLUSH_POLICY = "flush_policy";
        public static final String FLUSH_INTERVAL = "flush_interval";
        public static final String INCLUDE_FILTER = "include_filter";
        public static final String EXCLUDE_FILTER = "exclude_filter";
        public static final String TEST_INCLUDE_FILTER = "test_include_filter";
        public static final String TEST_EXCLUDE_FILTER = "test_exclude_filter";
        public static final String BLOCK_FILTERS = "block_filters";
        public static final String REGEXP_FILTERS = "regexp_filters";
        public static final String SHOULD_QUALIFY_JAVA_LANG = "should_qualify_java_lang";
        public static final String USING_DEFAULT_TEST_DETECTION = "using_default_test_detection";
        public static final String TEST_SOURCE_FOLDERS = "test_source_folders";
        public static final String SELECTED_TEST_SOURCE_FOLDERS = "selected_test_source_folders";
        public static final String INSTRUMENT_SELECTED_SOURCE_FOLDERS = "instrument_selected_source_folders";
        public static final String INSTRUMENTED_FOLDER_PATTERNS = "instrumented_source_folder_patterns";
        public static final String INSTRUMENTATION_LEVEL = "instrumentation_level";
        public static final String INSTRUMENT_LAMBDA = "instrument_lambda";
        public static final String RECREATE_OUTPUT_DIRS = "recreate_output_dirs";
    }
}

