/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.settings;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.BaseSettingsPage;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.InstrumentSourceFilteringComposite;
import org.openclover.eclipse.core.projects.settings.source.InstrumentationComposite;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;
import org.openclover.eclipse.core.projects.settings.source.SourceRootsWithPatternTreeContentProvider;
import org.openclover.eclipse.core.projects.settings.source.test.TestSourceFilteringComposite;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.widgets.ContextFilterModificationWidget;

public class ProjectPropertyPage
extends BaseSettingsPage
implements IWorkbenchPropertyPage {
    public static final String ID = "org.openclover.eclipse.core.properties.cloverProjectPropertyPage";
    private static final QualifiedName LAST_SELECTED_TAB_KEY = new QualifiedName("org.openclover.eclipse.core.properties.cloverProjectPropertyPage", "lastSelectedTab");
    private static final int SOURCE_TAB_INDEX = 2;
    private Panel panel;

    protected Control createContents(Composite composite) {
        try {
            this.panel = new Panel(composite, this);
            return this.panel;
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error creating project properties panel", e);
            return null;
        }
    }

    public static void focusSourceTab(IProject project) throws CoreException {
        project.getProject().setSessionProperty(LAST_SELECTED_TAB_KEY, (Object)2);
    }

    protected void performApply() {
        if (this.panel != null) {
            this.panel.performApply();
        }
    }

    public boolean performOk() {
        return this.panel == null || this.panel.performOk();
    }

    protected void performDefaults() {
        if (this.panel != null) {
            this.panel.performDefaults();
        }
    }

    public boolean performCancel() {
        return this.panel == null || this.panel.performCancel();
    }

    public boolean okToLeave() {
        return this.panel == null || this.panel.okToLeave();
    }

    public class Panel
    extends Composite {
        private IJavaProject project;
        private Button enableButton;
        private InstrumentationComposite instrumentationComposite;
        private InstrumentSourceFilteringComposite instrumentSourceFilteringComposite;
        private TestSourceFilteringComposite testSourceFilteringComposite;
        private ContextFilterModificationWidget contextFilter;
        public static final int HORIZONTAL_INDENT = 30;

        public Panel(Composite composite, PropertyPage propertyPage) throws CoreException {
            super(composite, 0);
            this.project = this.getJavaProject();
            this.setLayout((Layout)new GLH().marginHeight(0).marginWidth(0).getGridLayout());
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.enableButton = new Button((Composite)this, 32);
            this.enableButton.setText(CloverEclipsePluginMessages.ENABLE_CLOVER_COVERAGE());
            this.enableButton.setLayoutData((Object)gridData);
            gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            final TabFolder tabFolder = new TabFolder((Composite)this, 0);
            tabFolder.setLayoutData((Object)gridData);
            ProjectSettings settings = new ProjectSettings(this.project.getProject());
            this.instrumentationComposite = this.createInstrumentationTab(settings, tabFolder);
            this.contextFilter = this.createFilteringTab(settings, tabFolder);
            List<SourceFolderPattern> patterns = settings.getInstrumentedFolderPatterns();
            SourceRootsWithPatternTreeContentProvider instrumentedSrcRootsContentProvider = new SourceRootsWithPatternTreeContentProvider(this.project, patterns);
            this.instrumentSourceFilteringComposite = this.createSourceTab(settings, tabFolder, instrumentedSrcRootsContentProvider);
            this.testSourceFilteringComposite = this.createTestsTab(settings, tabFolder, instrumentedSrcRootsContentProvider);
            tabFolder.pack();
            Object lastIdx = this.project.getProject().getSessionProperty(LAST_SELECTED_TAB_KEY);
            if (lastIdx instanceof Integer) {
                tabFolder.setSelection(((Integer)lastIdx).intValue());
            }
            tabFolder.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        Panel.this.project.getProject().setSessionProperty(LAST_SELECTED_TAB_KEY, (Object)new Integer(tabFolder.getSelectionIndex()));
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            });
            this.enableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    tabFolder.setEnabled(Panel.this.enableButton.getSelection());
                }
            });
            try {
                this.enableButton.setSelection(CloverProject.isAppliedTo(this.project));
                tabFolder.setEnabled(this.enableButton.getSelection());
            }
            catch (CoreException e) {
                CloverPlugin.logError("Error initialising project properties panel", e);
                throw e;
            }
        }

        private IJavaProject getJavaProject() throws CoreException {
            return (IJavaProject)((IProject)ProjectPropertyPage.this.getElement()).getNature("org.eclipse.jdt.core.javanature");
        }

        private CloverProject getCloverProject() throws CoreException {
            return CloverProject.getFor((IProject)ProjectPropertyPage.this.getElement());
        }

        private InstrumentationComposite createInstrumentationTab(ProjectSettings properties, TabFolder tabFolder) throws CoreException {
            TabItem compilationItem = new TabItem(tabFolder, 0);
            compilationItem.setText(CloverEclipsePluginMessages.INSTRUMENTATION());
            InstrumentationComposite composite = new InstrumentationComposite((Composite)tabFolder, ProjectPropertyPage.this, properties, this.getCloverProject());
            compilationItem.setControl((Control)composite);
            return composite;
        }

        private InstrumentSourceFilteringComposite createSourceTab(ProjectSettings properties, TabFolder tabFolder, SourceRootsWithPatternTreeContentProvider contentProvider) {
            TabItem sourceItem = new TabItem(tabFolder, 0, 2);
            sourceItem.setText(CloverEclipsePluginMessages.SOURCE_FILES_TAB());
            InstrumentSourceFilteringComposite composite = new InstrumentSourceFilteringComposite((Composite)tabFolder, properties, contentProvider);
            composite.setLayout((Layout)new GridLayout(1, true));
            sourceItem.setControl((Control)composite);
            return composite;
        }

        private TestSourceFilteringComposite createTestsTab(ProjectSettings properties, TabFolder tabFolder, SourceRootsWithPatternTreeContentProvider contentProvider) {
            TabItem testsItem = new TabItem(tabFolder, 0);
            testsItem.setText(CloverEclipsePluginMessages.TEST_CLASSES_TAB());
            TestSourceFilteringComposite composite = new TestSourceFilteringComposite((Composite)tabFolder, this.project, properties, contentProvider);
            composite.setLayout((Layout)new GridLayout(1, true));
            testsItem.setControl((Control)composite);
            return composite;
        }

        private ContextFilterModificationWidget createFilteringTab(ProjectSettings properties, TabFolder tabFolder) throws CoreException {
            TabItem filteringItem = new TabItem(tabFolder, 0);
            filteringItem.setText(CloverEclipsePluginMessages.FILTERING());
            Composite filteringTabPanel = new Composite((Composite)tabFolder, 0);
            filteringTabPanel.setLayout((Layout)new GridLayout(1, true));
            filteringItem.setControl((Control)filteringTabPanel);
            ContextFilterModificationWidget contextFilter = new ContextFilterModificationWidget(filteringTabPanel, properties);
            contextFilter.setLayoutData(new GridData(1808));
            return contextFilter;
        }

        public boolean performCancel() {
            return true;
        }

        public boolean performApply() {
            if (this.okToLeave()) {
                try {
                    int flushInterval;
                    ProjectSettings properties = new ProjectSettings(this.project.getProject());
                    boolean rebuild = this.contextFilter.alertIfManualRebuildRequired();
                    this.contextFilter.store();
                    if (!rebuild && (this.instrumentSourceFilteringComposite.isModified() || this.testSourceFilteringComposite.isModified())) {
                        rebuild = InstrumentSourceFilteringComposite.askForRebuild();
                    }
                    this.instrumentSourceFilteringComposite.storeTo(properties);
                    this.testSourceFilteringComposite.storeTo(properties);
                    if (!rebuild && this.instrumentationComposite.isRebuildRequired()) {
                        rebuild = this.getCloverProject().okayToRebuild(this.getShell());
                    }
                    properties.shouldQualifyJavaLang(this.instrumentationComposite.isQualifyJavaLangReferences());
                    properties.setInstrumentationEnabled(this.instrumentationComposite.isInstrumentationEnabled());
                    properties.setInstrumentationLevel(this.instrumentationComposite.getInstrumentationLevel());
                    properties.setInstrumentLambda(this.instrumentationComposite.getInstrumentLambda());
                    properties.updateInitString(this.instrumentationComposite.isDefaultInitString(), this.instrumentationComposite.getCustomInitStringValue(), this.instrumentationComposite.isCustomInitStringRelative());
                    try {
                        flushInterval = this.instrumentationComposite.getFlushInterval();
                    }
                    catch (NumberFormatException e) {
                        flushInterval = 1000;
                    }
                    properties.updateFlushPolicy(this.instrumentationComposite.getFlushPolicy(), flushInterval);
                    properties.updateOutputRoot(this.instrumentationComposite.isProjectOutputDir(), this.instrumentationComposite.getCustomOutputDir(), this.instrumentationComposite.isCustomOutputDirRecreateOriginal());
                    if (this.enableButton.getSelection() ^ CloverProject.isAppliedTo(this.project)) {
                        return CloverProject.toggleWithUserFeedback(this.getShell(), this.project);
                    }
                    if (rebuild) {
                        try {
                            properties.getProject().build(15, null);
                        }
                        catch (CoreException e) {
                            CloverPlugin.logError("Unable to rebuild project", e);
                        }
                    }
                }
                catch (CoreException e) {
                    CloverPlugin.logError("Error applying properties", e);
                    ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_UNEXPECTED_WHILE_APPLY_PROPERTIES());
                    return false;
                }
                return true;
            }
            return false;
        }

        public boolean performOk() {
            return this.performApply();
        }

        public void performDefaults() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean okToLeave() {
            boolean okToLeave = false;
            if (!this.instrumentationComposite.isDefaultInitString() && this.instrumentationComposite.getCustomInitStringValue().length() == 0) {
                ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_CUSTOM_INITSTRING_NOT_EMPTY(), 3);
                return okToLeave;
            }
            if (this.instrumentationComposite.getFlushPolicy() == 1 || this.instrumentationComposite.getFlushPolicy() == 2) {
                try {
                    int flushInterval = this.instrumentationComposite.getFlushInterval();
                    if (flushInterval < 0) {
                        ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_FLUSH_INTERVAL_NOT_POSITIVE(), 3);
                        return okToLeave;
                    }
                }
                catch (NumberFormatException e) {
                    ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_FLUSH_INTERVAL_NOT_A_NUMBER(), 3);
                    return okToLeave;
                }
            }
            if (!this.instrumentationComposite.isProjectOutputDir() && this.instrumentationComposite.getCustomOutputDir().length() == 0) {
                ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_OUTPUT_DIR_NAME_IS_NULL(), 3);
                return okToLeave;
            }
            if (!this.instrumentationComposite.isProjectOutputDir() && this.instrumentationComposite.getCustomOutputDir().length() > 0) {
                IPackageFragment packageFragment;
                IPath path;
                try {
                    path = Path.fromOSString((String)this.instrumentationComposite.getCustomOutputDir());
                    packageFragment = this.project.findPackageFragment(this.project.getPath().append(path));
                }
                catch (JavaModelException ex) {
                    CloverPlugin.logError("Error applying properties", ex);
                    ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_UNEXPECTED_WHILE_CUSTOM_OUTPUT_DIR());
                    return false;
                }
                if (packageFragment != null) {
                    CloverPlugin.logDebug(CloverEclipsePluginMessages.ERROR_OUTPUT_FOLDER_HAS_SOURCES(path.toString(), packageFragment.getElementName()));
                    ProjectPropertyPage.this.setMessage(CloverEclipsePluginMessages.ERROR_OUTPUT_FOLDER_HAS_SOURCES(), 3);
                    return okToLeave;
                }
            }
            okToLeave = true;
            ProjectPropertyPage.this.setMessage(null);
            return okToLeave;
        }
    }
}

