/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;

public class ModelUtils {
    public static final int SEARCH_SELF_AND_DEPENDENTS = -1;
    public static final int SEARCH_SELF = 0;
    public static final int SEARCH_SELF_AND_DEPENDENCIES = 1;

    public static IType findTestCaseClass(int searchType, IJavaProject project, ClassInfo testClass) throws JavaModelException {
        IType type = null;
        if (project != null) {
            try {
                type = project.findType(testClass.getQualifiedName(), (IProgressMonitor)null);
                if (type == null) {
                    IProject other;
                    IProject[] projects = new IProject[]{};
                    if (searchType == -1) {
                        projects = project.getProject().getReferencingProjects();
                    } else if (searchType == 1) {
                        projects = project.getProject().getReferencedProjects();
                    }
                    IProject[] iProjectArray = projects;
                    int n = iProjectArray.length;
                    for (int i = 0; !(i >= n || CloverProject.isAppliedTo(other = iProjectArray[i]) && (type = ModelUtils.findTestCaseClass(searchType, JavaCore.create((IProject)other), testClass)) != null); ++i) {
                    }
                }
            }
            catch (CoreException e) {
                CloverPlugin.logError("Unable to look up test case class", e);
            }
        }
        return type;
    }

    public static IMethod findTestCaseMethod(int searchType, IJavaProject javaProject, TestCaseInfo testCase) throws JavaModelException {
        IType type = ModelUtils.findTestCaseClass(searchType, javaProject, testCase.getRuntimeType());
        FullMethodInfo cloverTestCaseMethod = testCase.getSourceMethod();
        IMethod[] methods = type == null ? new IMethod[]{} : type.getMethods();
        IMethod testCaseMethod = null;
        for (IMethod method : methods) {
            if (!method.getElementName().equals(cloverTestCaseMethod.getSimpleName())) continue;
            testCaseMethod = method;
            break;
        }
        return testCaseMethod;
    }
}

