/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.model;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.context.ContextSet;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.CoverageModelChangeEvent;
import org.openclover.eclipse.core.projects.model.DatabasePostLoadDecorator;
import org.openclover.eclipse.core.projects.model.DatabasePreLoadDecorator;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;

public class LoadDatabaseJob
extends Job {
    private static final QualifiedName DATABASE_PROPERTY = new QualifiedName("org.openclover.eclipse.core", "database");
    protected static final ISchedulingRule MUTEX_SCHEDULING_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule schedulingRule) {
            return schedulingRule == this;
        }

        public boolean isConflicting(ISchedulingRule schedulingRule) {
            return schedulingRule == this;
        }
    };
    public static final int LOAD_FAILED = 0;
    protected AtomicBoolean hasRun;
    protected volatile IStatus status;
    protected final CloverProject project;
    protected final DatabasePreLoadDecorator[] preLoadDecorators;
    protected final DatabasePostLoadDecorator[] postLoadDecorators;
    protected final ContextSet contextFilter;

    public LoadDatabaseJob(CloverProject project, CoverageModelChangeEvent changeEvent) {
        this("Loading Clover database for project " + project.getName(), project, changeEvent);
    }

    protected LoadDatabaseJob(String description, CloverProject project, CoverageModelChangeEvent changeEvent) {
        super(description);
        this.setPriority(50);
        this.setSystem(!changeEvent.isUserInitiated());
        this.setUser(changeEvent.isUserInitiated());
        this.setRule((ISchedulingRule)new MultiRule(new ISchedulingRule[]{MUTEX_SCHEDULING_RULE, project.getProject()}));
        this.hasRun = new AtomicBoolean(false);
        this.project = project;
        this.contextFilter = project.getSettings().getContextFilter();
        this.preLoadDecorators = changeEvent.getPreChangeDecorators();
        this.postLoadDecorators = changeEvent.getPostChangeDecorators();
    }

    protected void setDatabase(CloverDatabase database) {
        this.setProperty(DATABASE_PROPERTY, database);
    }

    public CloverDatabase getDatabase() {
        return (CloverDatabase)this.getProperty(DATABASE_PROPERTY);
    }

    protected IStatus run(IProgressMonitor monitor) {
        return this.doLoad(monitor);
    }

    public IStatus doLoad(IProgressMonitor monitor) {
        if (this.hasRun.compareAndSet(false, true)) {
            CloverPlugin.logVerbose("Loading coverage for project " + this.project.getName());
            ProjectSettings settings = this.project.getSettings();
            try {
                File registryFile = this.project.getRegistryFile();
                if (registryFile.exists()) {
                    this.setDatabase(this.loadDbAndCoverage(settings, registryFile, monitor));
                } else {
                    this.setDatabase(this.createNewDb(false, monitor));
                }
                this.status = Status.OK_STATUS;
            }
            catch (Throwable t) {
                try {
                    this.setDatabase(this.loadCoverage(this.createNewDb(true, monitor), monitor));
                }
                catch (Exception e) {
                    CloverPlugin.logError("Failed to create a fresh database after failing to load", e);
                }
                this.status = new Status(2, "org.openclover.eclipse.core", 0, "Background job: failed to load Clover database for project " + this.project.getName(), t);
            }
        }
        return this.status;
    }

    private CloverDatabase createNewDb(boolean becauseOfError, IProgressMonitor monitor) {
        this.preLoadDecorators(monitor);
        CloverDatabase database = this.newDbFromSettings(becauseOfError);
        this.postLoadDectorators(monitor, database);
        return database;
    }

    private CloverDatabase loadDbAndCoverage(ProjectSettings settings, File coverageDbFile, IProgressMonitor monitor) throws Exception {
        this.preLoadDecorators(monitor);
        CloverDatabase database = this.loadCoverage(this.loadDbNoCoverage(coverageDbFile), monitor);
        this.postLoadDectorators(monitor, database);
        return database;
    }

    protected CloverDatabase loadCoverage(CloverDatabase database, IProgressMonitor monitor) throws CloverException {
        database.loadCoverageData(this.project.newCoverageDataSpec(database));
        CloverPlugin.logVerbose("Finished loading database for project " + this.project.getName());
        return database;
    }

    private CloverDatabase loadDbNoCoverage(File coverageDbFile) throws CloverException, IOException {
        CloverDatabase database = this.loadDb(coverageDbFile);
        coverageDbFile.setLastModified(database.getRegistry().getVersion());
        return database;
    }

    private CloverDatabase newDbFromSettings(boolean becauseOfError) {
        if (becauseOfError) {
            this.project.flagStaleRegistryBecause(CloverEclipsePluginMessages.MARKERS_STALE_DB());
        }
        return this.project.newEmptyDatabase(this.contextFilter);
    }

    private CloverDatabase loadDb(File registryFile) throws CloverException, IOException {
        return new CloverDatabase(registryFile.getCanonicalPath(), this.project.newIncludeFilter(), this.project.getName(), this.project.getSettings().getContextRegistry().getContextsAsString(this.contextFilter), null);
    }

    private void postLoadDectorators(IProgressMonitor monitor, CloverDatabase database) {
        if (this.postLoadDecorators.length > 0) {
            CloverPlugin.logVerbose("Executing post-load decorators for project " + this.project.getName());
            for (DatabasePostLoadDecorator postLoadDecorator : this.postLoadDecorators) {
                try {
                    postLoadDecorator.decorate(this.project, database, monitor);
                }
                catch (Exception e) {
                    CloverPlugin.logError("Failed executing post-load decotrator " + postLoadDecorator);
                }
            }
        }
    }

    private void preLoadDecorators(IProgressMonitor monitor) {
        if (this.preLoadDecorators.length > 0) {
            CloverPlugin.logVerbose("Executing pre-load decorators for project " + this.project.getName());
            for (DatabasePreLoadDecorator preLoadDecorator : this.preLoadDecorators) {
                try {
                    preLoadDecorator.decorate(this.project, monitor);
                }
                catch (Exception e) {
                    CloverPlugin.logError("Failed executing pre-load decotrator " + preLoadDecorator);
                }
            }
        }
    }

    public boolean belongsTo(Object family) {
        return family == this;
    }
}

