/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.openclover.eclipse.core.CloverPlugin;

public class PathUtils {
    public static boolean isAncestorOrDescendantOfContainer(IContainer container, IResource resource) {
        return PathUtils.isDescendantOfContainer(container, resource) || PathUtils.isAncestorOfContainer(container, resource);
    }

    public static boolean isAncestorOfContainer(IContainer container, IResource resource) {
        return resource.getFullPath().isPrefixOf(container.getFullPath());
    }

    public static boolean isAncestorOfOrSameContainer(IContainer container, IResource resource) {
        return container.equals(resource) || resource.getFullPath().isPrefixOf(container.getFullPath());
    }

    public static boolean isDescendantOfContainer(IContainer container, IResource resource) {
        return container.getFullPath().isPrefixOf(resource.getFullPath());
    }

    public static IResource makeDerivedFoldersFor(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (parent instanceof IFolder) {
            PathUtils.makeDerivedFoldersFor((IResource)parent);
        }
        if (resource instanceof IFolder) {
            try {
                resource.refreshLocal(0, null);
            }
            catch (CoreException e) {
                CloverPlugin.logDebug("Unable to refresh folder to see if it exists or not: " + resource.getLocation(), e);
            }
            if (!resource.exists()) {
                PathUtils.makeDerivedFolder((IFolder)resource);
            }
        }
        return resource;
    }

    public static IResource makeFoldersFor(IResource resource) throws CoreException {
        IContainer parent = resource.getParent();
        if (parent instanceof IFolder) {
            PathUtils.makeFoldersFor((IResource)parent);
        }
        if (resource instanceof IFolder && !resource.exists()) {
            PathUtils.makeFolder((IFolder)resource);
        }
        return resource;
    }

    public static void makeFolder(IFolder folder) throws CoreException {
        folder.create(1024, true, null);
    }

    public static void makeDerivedFolder(IFolder folder) throws CoreException {
        folder.create(1025, true, null);
    }

    public static IContainer containerFor(IPath path) {
        if (ResourcesPlugin.getWorkspace().validatePath(path.toString(), 2).getCode() == 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        }
        if (ResourcesPlugin.getWorkspace().validatePath(path.toString(), 4).getCode() == 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(path.lastSegment());
        }
        return null;
    }
}

