/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import java.util.Date;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.compiler.BuildContext;
import org.eclipse.jdt.core.compiler.CompilationParticipant;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.Markers;

public class CloverCompilationParticipant
extends CompilationParticipant {
    public void buildStarting(BuildContext[] files, boolean isBatch) {
        if (files.length == 0) {
            return;
        }
        CloverPlugin.logVerbose("----CLOVER: BUILD ITERATION STARTED : " + new Date() + "----");
        try {
            CloverProject project = CloverProject.getFor(files[0].getFile().getProject());
            if (project != null) {
                project.getBuildCoordinator().registerFilesForInstrumentation(files);
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to instrument and compile", e);
            try {
                Markers.createCloverStaleDbMarker((IResource)files[0].getFile().getProject(), "Clover was unable to fully instrument and compile for this project. Please perform a clean rebuild. " + e.getMessage());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        CloverPlugin.logVerbose("----CLOVER: BUILD ITERATION ENDED : " + new Date() + "----");
        super.buildStarting(files, isBatch);
    }

    public void cleanStarting(IJavaProject project) {
    }

    public boolean isActive(IJavaProject project) {
        try {
            return CloverProject.isAppliedTo(project);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to determine if compilation participant is active for project " + project.getProject().getName(), e);
            return false;
        }
    }
}

