/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.openclover.eclipse.core.projects.builder.PathUtils;

public class CleaningVisitor
implements IResourceVisitor {
    private IFolder parent;
    private IProgressMonitor monitor;

    public CleaningVisitor(IFolder parent, IProgressMonitor monitor) {
        this.parent = parent;
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (PathUtils.isAncestorOfOrSameContainer((IContainer)this.parent, resource)) {
            return true;
        }
        if (PathUtils.isDescendantOfContainer((IContainer)this.parent, resource)) {
            this.monitor.subTask("Removing " + resource.getFullPath().toOSString());
            resource.delete(1, null);
            return true;
        }
        return false;
    }
}

