/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.projects;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;

public abstract class CloveredProjectImageDescriptor
extends CompositeImageDescriptor {
    private final ImageDescriptor originalImage;

    protected CloveredProjectImageDescriptor(ImageDescriptor originalImage) {
        this.originalImage = originalImage;
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.originalImage.getImageData(), 0, 0);
        this.drawImage(this.getOverlayImageData(), 0, 0);
    }

    protected abstract ImageData getOverlayImageData();

    protected Point getSize() {
        return new Point(this.originalImage.getImageData().width, this.originalImage.getImageData().height);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass() && ((CloveredProjectImageDescriptor)((Object)obj)).originalImage.equals(this.originalImage);
    }

    public int hashCode() {
        return this.originalImage.hashCode() ^ 7;
    }

    public static ImageDescriptor imageDescriptorFor(IProject project, ImageDescriptor imageDescriptor) {
        try {
            if (CloverProject.isAppliedTo(project)) {
                CloverProject cloverProject = CloverProject.getFor(project);
                if (!cloverProject.getSettings().isInstrumentationEnabled()) {
                    return new NoInstrumentationState(imageDescriptor);
                }
                return new OkState(imageDescriptor);
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error determining Clovered project icon", e);
        }
        return imageDescriptor;
    }

    private static class NoInstrumentationState
    extends CloveredProjectImageDescriptor {
        private NoInstrumentationState(ImageDescriptor originalImage) {
            super(originalImage);
        }

        @Override
        protected ImageData getOverlayImageData() {
            return CloverPlugin.getImage("icons/ovr16/clovered_nocompile.gif").getImageData();
        }
    }

    private static class ErrorState
    extends CloveredProjectImageDescriptor {
        private ErrorState(ImageDescriptor originalImage) {
            super(originalImage);
        }

        @Override
        protected ImageData getOverlayImageData() {
            return CloverPlugin.getImage("icons/ovr16/clovered_error.gif").getImageData();
        }
    }

    private static class OkState
    extends CloveredProjectImageDescriptor {
        public OkState(ImageDescriptor originalImage) {
            super(originalImage);
        }

        @Override
        protected ImageData getOverlayImageData() {
            return CloverPlugin.getImage("icons/ovr16/clovered.gif").getImageData();
        }
    }
}

