/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.launching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;
import org.openclover.eclipse.core.CloverPlugin;

public class CloverTabGroup
implements ILaunchConfigurationTabGroup,
IExecutableExtension {
    private static final String LAUNCH_TABGROUPS_EXTENSION = "org.eclipse.debug.ui.launchConfigurationTabGroups";
    private ILaunchConfigurationTabGroup delegate;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.delegate = this.delegateTabGroupFor(config.getAttribute("type"));
    }

    protected ILaunchConfigurationTabGroup delegateTabGroupFor(String launchType) throws CoreException {
        IConfigurationElement element = this.findRunModeConfigurationFor(launchType);
        if (element == null) {
            throw CloverPlugin.logAndThrowError("There are no tab groups registered to run for launch type of " + launchType);
        }
        return (ILaunchConfigurationTabGroup)element.createExecutableExtension("class");
    }

    private IConfigurationElement findRunModeConfigurationFor(String type) {
        IConfigurationElement[] tabGroupConfigs = Platform.getExtensionRegistry().getExtensionPoint(LAUNCH_TABGROUPS_EXTENSION).getConfigurationElements();
        IConfigurationElement result = null;
        for (IConfigurationElement tabGroupConfig : tabGroupConfigs) {
            if (!type.equals(tabGroupConfig.getAttribute("type"))) continue;
            IConfigurationElement[] launchModeConfigs = tabGroupConfig.getChildren("launchMode");
            if (launchModeConfigs.length > 0) {
                for (IConfigurationElement launchModeConfig : launchModeConfigs) {
                    if (!"run".equals(launchModeConfig.getAttribute("mode"))) continue;
                    return tabGroupConfig;
                }
                continue;
            }
            result = tabGroupConfig;
        }
        return result;
    }

    public void createTabs(ILaunchConfigurationDialog dialog, String mode) {
        this.delegate.createTabs(dialog, mode);
    }

    public ILaunchConfigurationTab[] getTabs() {
        return this.delegate.getTabs();
    }

    public void dispose() {
        this.delegate.dispose();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.delegate.setDefaults(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.delegate.initializeFrom(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.delegate.performApply(configuration);
    }

    public void launched(ILaunch launch) {
    }
}

