/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.exclusion;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.ui.PlatformUI;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.exclusion.ExclusionFilter;
import org.openclover.eclipse.core.exclusion.ExclusionUtil;
import org.openclover.eclipse.core.exclusion.ICloverExcludable;
import org.openclover.eclipse.core.projects.CloverProject;

public class ExclusionLabelDecorator
implements ILightweightLabelDecorator {
    private static final int QUADRANT = 1;

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof ICloverExcludable && CloverPlugin.getInstance().getInstallationSettings().isShowExclusionAnnotations()) {
            ICloverExcludable excludable = (ICloverExcludable)element;
            if (ExclusionUtil.isPresent(excludable, true)) {
                decoration.addOverlay(CloverPlugin.getImageDescriptor("icons/ovr16/clover_ovl_gray.gif"), 1);
            } else if (ExclusionUtil.isPresent(excludable, false)) {
                decoration.addOverlay(CloverPlugin.getImageDescriptor("icons/ovr16/clover_ovl_green.gif"), 1);
            } else if (excludable.isLeaf()) {
                CloverProject cloverProject;
                IResource res = excludable.getJavaElement().getResource();
                try {
                    cloverProject = CloverProject.getFor(excludable.getJavaElement().getJavaProject());
                }
                catch (CoreException e) {
                    cloverProject = null;
                }
                if (cloverProject != null && res instanceof IFile) {
                    boolean excluded = new ExclusionFilter(cloverProject.getSettings()).isFilteredOut((IFile)res);
                    decoration.addOverlay(CloverPlugin.getImageDescriptor(excluded ? "icons/ovr16/clover_ovl_gray.gif" : "icons/ovr16/clover_ovl_green.gif"), 1);
                }
            }
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public static void decorationChanged() {
        PlatformUI.getWorkbench().getDecoratorManager().update("org.openclover.eclipse.core.exclusionDecorator");
    }
}

