/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.exclusion;

import com.atlassian.clover.util.FilterUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;

public class ExclusionFilter {
    protected final String[] includeFilter;
    protected final String[] excludeFilter;

    public ExclusionFilter(ProjectSettings settings) {
        boolean instrumentSelected = settings.isInstrumentSelectedSourceFolders();
        if (instrumentSelected) {
            List<SourceFolderPattern> folderPatterns = settings.getInstrumentedFolderPatterns();
            this.includeFilter = ExclusionFilter.calculateIncludeFilter(folderPatterns);
            this.excludeFilter = ExclusionFilter.calculateExcludeFilter(folderPatterns);
        } else {
            this.includeFilter = settings.calculateIncludeFilter();
            this.excludeFilter = settings.calculateExcludeFilter();
        }
    }

    public boolean isFilteredOut(IFile file) {
        String path = file.getProjectRelativePath().toPortableString();
        return !FilterUtils.isIncluded(path, this.excludeFilter, this.includeFilter, true) || CloverPlugin.getInstance().isInWorkingSetMode() && !CloverPlugin.getInstance().getCloverWorkingSet().includes((IAdaptable)file);
    }

    public String[] getIncludeFilter() {
        return this.includeFilter;
    }

    public String[] getExcludeFilter() {
        return this.excludeFilter;
    }

    static String[] calculateIncludeFilter(List<SourceFolderPattern> folderPatterns) {
        ArrayList<String> list = new ArrayList<String>(folderPatterns.size());
        for (SourceFolderPattern pattern : folderPatterns) {
            if (!pattern.isEnabled()) continue;
            list.addAll(ExclusionFilter.unroll(pattern.getSrcPath(), pattern.getIncludePattern()));
        }
        return list.toArray(new String[list.size()]);
    }

    static String[] calculateExcludeFilter(List<SourceFolderPattern> folderPatterns) {
        ArrayList<String> list = new ArrayList<String>(folderPatterns.size());
        for (SourceFolderPattern pattern : folderPatterns) {
            if (!pattern.isEnabled()) continue;
            list.addAll(ExclusionFilter.unroll(pattern.getSrcPath(), pattern.getExcludePattern()));
        }
        return list.toArray(new String[list.size()]);
    }

    static List<String> unroll(String folder, String expression) {
        String[] patterns = expression.split(",");
        ArrayList<String> list = new ArrayList<String>(patterns.length);
        for (String pattern : patterns) {
            if ((pattern = pattern.trim()).length() == 0) continue;
            StringBuilder sb = new StringBuilder(folder.length() + 1 + pattern.length());
            sb.append(folder);
            if (pattern.charAt(0) != '/') {
                sb.append('/');
            }
            sb.append(pattern);
            list.add(sb.toString());
        }
        return list;
    }
}

