/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.exclusion;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.exclusion.BaseActionDelegate;
import org.openclover.eclipse.core.exclusion.ExclusionUtil;
import org.openclover.eclipse.core.exclusion.ICloverExcludable;
import org.openclover.eclipse.core.exclusion.ScheduleRebuildJob;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.settings.ProjectSettings;
import org.openclover.eclipse.core.projects.settings.source.SourceFolderPattern;

public abstract class BaseToggleActionDelegate
extends BaseActionDelegate {
    public void run(IAction action) {
        if (this.selectedElement != null) {
            if (ExclusionUtil.togglePresence(this.selectedElement, this.isExclude(), this.isSourceRootBased())) {
                new ScheduleRebuildJob(this.selectedElement.getProject(), 6).schedule();
            } else {
                this.touch(this.selectedElement);
            }
        }
    }

    @Override
    public void selectionChanged(IAction action, ISelection selection) {
        super.selectionChanged(action, selection);
        if (this.selectedElement != null) {
            boolean sourceRootBased = this.isSourceRootBased();
            StringBuilder sb = new StringBuilder(this.getActionName());
            if (sourceRootBased) {
                sb.append(" [").append(this.selectedElement.getPackageFragmentRoot().getResource().getProjectRelativePath().toString()).append("] ");
            } else {
                sb.append(" ");
            }
            sb.append(this.selectedElement.getPath());
            action.setText(sb.toString());
            action.setChecked(ExclusionUtil.isPresent(this.selectedElement, this.isExclude(), sourceRootBased));
            action.setEnabled(this.shouldEnable(this.selectedElement));
        }
    }

    private void touch(final ICloverExcludable selectedElement) {
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor progressMonitor) throws CoreException {
                IJavaElement javaElement = selectedElement.getJavaElement();
                CloverPlugin.logVerbose("Requesting rebuild of " + javaElement.getElementName());
                if (selectedElement.isLeaf()) {
                    javaElement.getResource().touch(progressMonitor);
                } else {
                    String rootName = javaElement instanceof IPackageFragmentRoot ? "" : javaElement.getElementName();
                    String rootPrefix = rootName.length() == 0 ? "" : rootName + '.';
                    Collection<IPackageFragmentRoot> roots = BaseToggleActionDelegate.this.isSourceRootBased() ? Collections.singleton(selectedElement.getPackageFragmentRoot()) : Arrays.asList(javaElement.getJavaProject().getAllPackageFragmentRoots());
                    for (IPackageFragmentRoot srcRoot : roots) {
                        IJavaElement[] packageFragments;
                        if (srcRoot.getKind() != 1) continue;
                        for (IJavaElement fragment : packageFragments = srcRoot.getChildren()) {
                            String name = fragment.getElementName();
                            if (rootName.length() != 0 && !name.equals(rootName) && !name.startsWith(rootPrefix)) continue;
                            for (ICompilationUnit cu : ((IPackageFragment)fragment).getCompilationUnits()) {
                                cu.getResource().touch(progressMonitor);
                            }
                        }
                    }
                }
                new ScheduleRebuildJob(selectedElement.getProject(), 9).schedule();
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(runnable, null);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Error touching resource " + selectedElement.getJavaElement().getElementName(), e);
        }
    }

    private boolean isSourceRootBased() {
        try {
            CloverProject cloverProject = CloverProject.getFor(this.selectedElement.getProject());
            return cloverProject != null && cloverProject.getSettings().isInstrumentSelectedSourceFolders();
        }
        catch (CoreException e) {
            return false;
        }
    }

    private boolean shouldEnable(ICloverExcludable element) {
        CloverProject cloverProject;
        try {
            cloverProject = CloverProject.getFor(element.getProject());
        }
        catch (CoreException e) {
            return false;
        }
        if (cloverProject == null) {
            return false;
        }
        ProjectSettings settings = cloverProject.getSettings();
        if (!settings.isInstrumentSelectedSourceFolders()) {
            return true;
        }
        String path = element.getPackageFragmentRoot().getResource().getProjectRelativePath().toString();
        for (SourceFolderPattern sfp : settings.getInstrumentedFolderPatterns()) {
            if (!path.equals(sfp.getSrcPath())) continue;
            return sfp.isEnabled();
        }
        return false;
    }

    protected abstract String getActionName();

    protected abstract boolean isExclude();
}

