/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core;

import com.atlassian.clover.Logger;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

class PluginLoggingAdapter
extends Logger {
    private ILog log;
    private boolean enabled;

    PluginLoggingAdapter(ILog log, boolean enabled) {
        this.log = log;
        this.enabled = enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void log(int level, String msg, Throwable t) {
        if (this.enabled && !PluginLoggingAdapter.canIgnore(level)) {
            int eclipseLevel;
            switch (level) {
                case 3: 
                case 4: {
                    eclipseLevel = 0;
                    break;
                }
                case 2: {
                    eclipseLevel = 1;
                    break;
                }
                case 1: {
                    eclipseLevel = 2;
                    break;
                }
                case 0: {
                    eclipseLevel = 4;
                    break;
                }
                default: {
                    eclipseLevel = 0;
                }
            }
            this.log.log((IStatus)new Status(eclipseLevel, "org.openclover.eclipse.core", 0, msg, t));
        }
    }
}

