/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtreemap.ktreemap;

import java.util.ArrayList;
import java.util.List;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.swt.graphics.Rectangle;

public abstract class SplitStrategy {
    public void calculatePositions(TreeMapNode root) {
        if (root == null) {
            return;
        }
        List<TreeMapNode> children = root.getChildren();
        if (children != null) {
            this.calculatePositionsRec(root.getBounds(), this.sumWeight(children), children);
        }
    }

    public abstract void splitElements(List<TreeMapNode> var1, List<TreeMapNode> var2, List<TreeMapNode> var3);

    public double sumWeight(List<TreeMapNode> children) {
        double d = 0.0;
        if (children != null) {
            for (TreeMapNode node : children) {
                d += node.getWeight();
            }
        }
        return d;
    }

    protected void calculatePositionsRec(Rectangle bounds, double weight0, List<TreeMapNode> children) {
        if (children.size() == 1) {
            TreeMapNode f = children.get(0);
            if (f.isLeaf()) {
                int h;
                int w = bounds.width - TreeMapNode.getBorder();
                if (w < 0) {
                    w = 0;
                }
                if ((h = bounds.height - TreeMapNode.getBorder()) < 0) {
                    h = 0;
                }
                Rectangle newBounds = new Rectangle(bounds.x + TreeMapNode.getBorder(), bounds.y + TreeMapNode.getBorder(), w, h);
                f.setBounds(newBounds);
            } else {
                int h;
                f.setBounds(bounds);
                int bSub = TreeMapNode.getBorder() > 1 ? 2 : (TreeMapNode.getBorder() == 1 ? 1 : 0);
                int w = bounds.width - bSub;
                if (w < 0) {
                    w = 0;
                }
                if ((h = bounds.height - bSub) < 0) {
                    h = 0;
                }
                TreeMapNode.setBorder(TreeMapNode.getBorder() - bSub);
                Rectangle newBounds = new Rectangle(bounds.x + bSub, bounds.y + bSub, w, h);
                this.calculatePositionsRec(newBounds, weight0, f.getChildren());
                TreeMapNode.setBorder(TreeMapNode.getBorder() + bSub);
            }
        } else {
            int y2;
            int x2;
            int h2;
            int h1;
            int w2;
            int w1;
            ArrayList<TreeMapNode> group1 = new ArrayList<TreeMapNode>();
            ArrayList<TreeMapNode> group2 = new ArrayList<TreeMapNode>();
            this.splitElements(children, group1, group2);
            double weight1 = this.sumWeight(group1);
            double weight2 = this.sumWeight(group2);
            if (bounds.width > bounds.height) {
                w1 = (int)((double)bounds.width * weight1 / weight0);
                w2 = bounds.width - w1;
                h1 = bounds.height;
                h2 = bounds.height;
                x2 = bounds.x + w1;
                y2 = bounds.y;
            } else {
                w1 = bounds.width;
                w2 = bounds.width;
                h1 = (int)((double)bounds.height * weight1 / weight0);
                h2 = bounds.height - h1;
                x2 = bounds.x;
                y2 = bounds.y + h1;
            }
            Rectangle bounds1 = new Rectangle(bounds.x, bounds.y, w1, h1);
            this.calculatePositionsRec(bounds1, weight1, group1);
            Rectangle bounds2 = new Rectangle(x2, y2, w2, h2);
            this.calculatePositionsRec(bounds2, weight2, group2);
        }
    }

    protected void sortList(List<TreeMapNode> v) {
        for (int i = 0; i < v.size(); ++i) {
            for (int j = v.size() - 1; j > i; --j) {
                if (!(v.get(j).getWeight() > v.get(j - 1).getWeight())) continue;
                TreeMapNode tmn = v.get(j);
                v.set(j, v.get(j - 1));
                v.set(j - 1, tmn);
            }
        }
    }
}

