/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.html.source.java;

import clover.antlr.Token;
import clover.antlr.TokenStreamException;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.instr.java.JavaLexer;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.reporters.html.source.SourceTraverser;
import com.atlassian.clover.reporters.html.source.java.JavaKeywords;
import com.atlassian.clover.reporters.html.source.java.JavaSourceListener;
import com.atlassian.clover.reporters.html.source.java.JavadocTags;
import java.io.Reader;

public final class JavaTokenTraverser
implements SourceTraverser<JavaSourceListener> {
    @Override
    public void traverse(Reader sourceReader, FullFileInfo fileInfo, JavaSourceListener listener) throws TokenStreamException {
        Token token;
        JavaLexer lexer = new JavaLexer(sourceReader, new JavaInstrumentationConfig());
        Token prev = token = lexer.nextToken();
        StringBuilder currentChunk = new StringBuilder();
        StringBuilder accumName = new StringBuilder();
        boolean gatherPkgIdent = false;
        boolean gatherImportIdent = false;
        listener.onStartDocument();
        while (prev != null && 1 != prev.getType()) {
            if (token != null && token.getType() == prev.getType()) {
                currentChunk.append(token.getText());
            } else {
                if (149 == prev.getType()) {
                    JavaTokenTraverser.processWhiteSpace(currentChunk.toString(), listener);
                } else if (145 == prev.getType()) {
                    listener.onStringLiteral(currentChunk.toString());
                } else if (150 == prev.getType()) {
                    listener.onCommentChunk(currentChunk.toString());
                } else if (151 == prev.getType()) {
                    JavaTokenTraverser.processComment(currentChunk.toString(), listener);
                } else if (JavaKeywords.contains(prev.getType())) {
                    listener.onKeyword(currentChunk.toString());
                    gatherPkgIdent = prev.getType() == 50;
                    gatherImportIdent = prev.getType() == 51;
                } else if (gatherPkgIdent || gatherImportIdent) {
                    if (48 == prev.getType()) {
                        if (gatherImportIdent) {
                            listener.onImport(accumName.toString());
                        }
                        accumName = new StringBuilder();
                        gatherPkgIdent = false;
                        gatherImportIdent = false;
                        listener.onChunk(currentChunk.toString());
                    } else if (54 == prev.getType()) {
                        accumName.append((CharSequence)currentChunk);
                        listener.onChunk(currentChunk.toString());
                    } else if (44 == prev.getType()) {
                        accumName.append((CharSequence)currentChunk);
                        if (gatherPkgIdent) {
                            listener.onPackageSegment(accumName.toString(), currentChunk.toString());
                        } else {
                            listener.onImportSegment(accumName.toString(), currentChunk.toString());
                        }
                    } else {
                        listener.onChunk(currentChunk.toString());
                    }
                } else if (44 == prev.getType()) {
                    listener.onIdentifier(currentChunk.toString());
                } else {
                    listener.onChunk(currentChunk.toString());
                }
                currentChunk = new StringBuilder();
                currentChunk.append(token.getText());
            }
            prev = token;
            token = lexer.nextToken();
        }
        listener.onEndDocument();
    }

    public static void processWhiteSpace(String whitespace, JavaSourceListener listener) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < whitespace.length()) {
            char c2;
            boolean atNewLine = false;
            char c1 = whitespace.charAt(i);
            char c = c2 = i + 1 < whitespace.length() ? whitespace.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    listener.onChunk(b.toString());
                    b = new StringBuilder();
                }
                listener.onNewLine();
            } else {
                b.append(c1);
            }
            ++i;
        }
        if (b.length() > 0) {
            listener.onChunk(b.toString());
        }
    }

    public static void processComment(String comment, JavaSourceListener listener) {
        StringBuilder b = new StringBuilder();
        int i = 0;
        boolean inTag = false;
        while (i < comment.length()) {
            char c2;
            boolean atNewLine = false;
            char c1 = comment.charAt(i);
            char c = c2 = i + 1 < comment.length() ? comment.charAt(i + 1) : (char)'\u0000';
            if (c1 == '\r' && c2 == '\n') {
                atNewLine = true;
                ++i;
            } else if (c1 == '\r' || c1 == '\n') {
                atNewLine = true;
            }
            if (!inTag && c1 == '@' && Character.isLetter(c2)) {
                inTag = true;
                listener.onCommentChunk(b.toString());
                b = new StringBuilder();
            } else if (inTag && !Character.isLetter(c1)) {
                inTag = false;
                String tag = b.toString();
                if (JavadocTags.contains(tag.substring(1))) {
                    listener.onJavadocTag(tag);
                    b = new StringBuilder();
                }
            }
            if (atNewLine) {
                if (b.length() > 0) {
                    listener.onCommentChunk(b.toString());
                    b = new StringBuilder();
                }
                listener.onNewLine();
            } else {
                b.append(c1);
            }
            ++i;
        }
        if (b.length() > 0) {
            String left = b.toString();
            if (inTag && JavadocTags.contains(left)) {
                listener.onJavadocTag(left);
            } else {
                listener.onCommentChunk(left);
            }
        }
    }
}

