/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.Logger;
import com_atlassian_clover.TestNameSniffer;
import java.lang.reflect.Field;

public class TestNameSnifferHelper {
    public static TestNameSniffer lookupTestSnifferField(Class currentTestClass) {
        try {
            Field sniffer = currentTestClass.getField("__CLR4_5_1_TEST_NAME_SNIFFER");
            if (sniffer.getType().isAssignableFrom(TestNameSniffer.class)) {
                return (TestNameSniffer)sniffer.get(null);
            }
            Logger.getInstance().debug("Unexpected type of the __CLR4_5_1_TEST_NAME_SNIFFER field: " + sniffer.getType().getName() + " - ignoring. Test name found during instrumentation may differ from the actual name of the test at runtime.");
        }
        catch (NoSuchFieldException ex) {
            Logger.getInstance().debug("Field __CLR4_5_1_TEST_NAME_SNIFFER was not found in an instance of " + currentTestClass.getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        catch (IllegalAccessException | SecurityException ex) {
            Logger.getInstance().debug("Field __CLR4_5_1_TEST_NAME_SNIFFER couldn't be accessed in an instance of " + currentTestClass.getName() + ". Test name found during instrumentation may differ from the actual name of the test at runtime.", ex);
        }
        return null;
    }
}

