/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets.columns;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.CustomColumnDefinition;
import org.openclover.util.Lists;
import org.openclover.util.Sets;

class ColumnDefinitionsModel {
    private LinkedHashSet<ColumnDefinition> remaining;
    private LinkedHashSet<ColumnDefinition> assigned;
    private LinkedHashSet<PropertyChangeListener> listeners;
    private LinkedHashSet<ColumnDefinition> allColumns;

    public ColumnDefinitionsModel(ColumnDefinition[] selectedColumns, ColumnDefinition[] allColumns) {
        this.allColumns = new LinkedHashSet<ColumnDefinition>(Arrays.asList(allColumns));
        this.listeners = new LinkedHashSet();
        this.assigned = new LinkedHashSet<ColumnDefinition>(Arrays.asList(selectedColumns));
        this.remaining = new LinkedHashSet<ColumnDefinition>(Arrays.asList(allColumns));
        this.remaining.removeAll(this.assigned);
    }

    public void addListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void dispose() {
        this.listeners.clear();
        this.remaining.clear();
        this.assigned.clear();
    }

    public List<ColumnDefinition> getAssigned() {
        return Lists.newLinkedList(this.assigned);
    }

    private static Set<ColumnDefinition> getColumns(Set<ColumnDefinition> columns, boolean customColumns) {
        LinkedHashSet<ColumnDefinition> clippedColumns = new LinkedHashSet<ColumnDefinition>(columns);
        Iterator iter = clippedColumns.iterator();
        while (iter.hasNext()) {
            if (!(customColumns ^ ((ColumnDefinition)iter.next()).isCustom())) continue;
            iter.remove();
        }
        return clippedColumns;
    }

    public Set<ColumnDefinition> getRemainingBuiltins() {
        return ColumnDefinitionsModel.getColumns(this.remaining, false);
    }

    public Set<ColumnDefinition> getRemainingCustoms() {
        return ColumnDefinitionsModel.getColumns(this.remaining, true);
    }

    public void assign(ColumnDefinition column) {
        this.remaining.remove(column);
        this.assigned.add(column);
        this.fireModelChanged();
    }

    public void assignAll(boolean customColumns) {
        Set<ColumnDefinition> toBeAssigned = ColumnDefinitionsModel.getColumns(this.remaining, customColumns);
        this.assigned.addAll(toBeAssigned);
        this.remaining.removeAll(toBeAssigned);
        this.fireModelChanged();
    }

    public boolean deassignAll() {
        HashSet<ColumnDefinition> toBeDeassigned = Sets.newHashSet(this.assigned);
        Iterator iter = toBeDeassigned.iterator();
        while (iter.hasNext()) {
            if (!((ColumnDefinition)iter.next()).isLocked()) continue;
            iter.remove();
        }
        boolean allDeassigned = toBeDeassigned.size() == this.assigned.size();
        this.assigned.removeAll(toBeDeassigned);
        this.remaining.addAll(toBeDeassigned);
        this.fireModelChanged();
        return allDeassigned;
    }

    public boolean deassign(ColumnDefinition column) {
        if (!column.isLocked()) {
            this.remaining.add(column);
            this.assigned.remove(column);
            this.fireModelChanged();
            return true;
        }
        return false;
    }

    private void fireModelChanged() {
        PropertyChangeEvent event = new PropertyChangeEvent(this, "*", null, null);
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(event);
        }
    }

    public Set<ColumnDefinition> getCustomColumns() {
        return ColumnDefinitionsModel.getColumns(this.allColumns, true);
    }

    public void addCustomColumn(CustomColumnDefinition column) {
        this.allColumns.add(column);
        this.remaining.add(column);
        this.fireModelChanged();
    }

    public void replaceCustomColumn(CustomColumnDefinition original, CustomColumnDefinition updated) {
        this.allColumns = this.replace(this.allColumns, original, updated);
        this.remaining = this.replace(this.remaining, original, updated);
        this.assigned = this.replace(this.assigned, original, updated);
        this.fireModelChanged();
    }

    public void removeCustomColumn(CustomColumnDefinition customColumnDefinition) {
        this.allColumns.remove(customColumnDefinition);
        this.remaining.remove(customColumnDefinition);
        this.assigned.remove(customColumnDefinition);
        this.fireModelChanged();
    }

    public void moveAssignedUp(ColumnDefinition column) {
        this.assigned = this.move(this.assigned, column, -1);
        this.fireModelChanged();
    }

    public void moveAssignedDown(ColumnDefinition column) {
        this.assigned = this.move(this.assigned, column, 1);
        this.fireModelChanged();
    }

    private LinkedHashSet<ColumnDefinition> move(LinkedHashSet<ColumnDefinition> set, ColumnDefinition column, int movement) {
        ColumnDefinition[] objects = set.toArray(new ColumnDefinition[set.size()]);
        for (int i = 0; i < objects.length; ++i) {
            if (objects[i] != column) continue;
            ColumnDefinition temp = objects[i];
            objects[i] = objects[i + movement];
            objects[i + movement] = temp;
            break;
        }
        return new LinkedHashSet<ColumnDefinition>(Arrays.asList(objects));
    }

    private LinkedHashSet<ColumnDefinition> replace(LinkedHashSet<ColumnDefinition> set, ColumnDefinition orig, ColumnDefinition updated) {
        LinkedList<ColumnDefinition> list = Lists.newLinkedList(set);
        Collections.replaceAll(list, orig, updated);
        return new LinkedHashSet<ColumnDefinition>(list);
    }

    public Set<ColumnDefinition> getBuiltintColumns() {
        return ColumnDefinitionsModel.getColumns(this.allColumns, false);
    }
}

