/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets;

import java.util.Set;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.CloverPluginIcons;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.eclipse.core.upgrade.hooks.ConfigUninstaller;
import org.openclover.util.Sets;

public class ViewAlertContainer
extends Composite
implements DatabaseChangeListener {
    private Composite alerts;
    private Composite content;
    private Alert hookUninstallLink;

    public ViewAlertContainer(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GLH(1, false).marginHeight(0).marginWidth(0).verticalSpacing(0).getGridLayout());
        this.alerts = new Composite((Composite)this, 0);
        this.alerts.setLayoutData((Object)new GridData(768));
        this.alerts.setLayout((Layout)new GLH(1, false).marginHeight(0).marginWidth(0).verticalSpacing(0).getGridLayout());
        this.hookUninstallLink = new Alert(AlertStyle.WARNING, this.alerts, false, "Clover has been upgraded but needs your attention.", "You have upgraded from a previous version of Clover which required modification to Eclipse's config.ini file. These modifications are no longer required. <a>Clover can undo these changes for you</a>.");
        this.hookUninstallLink.addExplanationLinkListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (new ConfigUninstaller().run()) {
                    ViewAlertContainer.this.updateHookUninstallAlert();
                }
            }
        });
    }

    public void setContent(SashForm content) {
        this.content = content;
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent event) {
        if (event.isForWorkspace()) {
            this.updateLinks(false);
        }
    }

    private void updateHookUninstallAlert() {
        SwtUtils.gridDataFor((Control)this.hookUninstallLink).exclude = !new ConfigUninstaller().isHookInstalled();
        this.hookUninstallLink.setVisible(!SwtUtils.gridDataFor((Control)this.hookUninstallLink).exclude);
    }

    public void updateLinks() {
        this.updateLinks(true);
    }

    private void updateLinks(boolean onInit) {
        this.run(new Runnable(){

            @Override
            public void run() {
                ViewAlertContainer.this.updateHookUninstallAlert();
                ViewAlertContainer.this.updateContainerVisibility();
            }
        }, onInit);
    }

    private void updateContainerVisibility() {
        SwtUtils.gridDataFor((Control)this.alerts).exclude = SwtUtils.gridDataFor((Control)this.hookUninstallLink).exclude;
        this.alerts.setVisible(!SwtUtils.gridDataFor((Control)this.alerts).exclude);
        this.getParent().layout(true, true);
    }

    private void run(Runnable work, boolean onInit) {
        if (onInit) {
            work.run();
        } else {
            Display.getDefault().syncExec(work);
        }
    }

    private class AlertPopup
    extends PopupDialog {
        private final String text;
        private Link link;
        private Point location;
        private Set<SelectionListener> pendingListeners;

        public AlertPopup(Shell parent, String text) {
            super(parent, 4, true, false, false, false, false, null, null);
            this.pendingListeners = Sets.newHashSet();
            this.text = text;
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(1, false));
            this.link = new Link(container, 0);
            this.link.setText(this.text);
            SwtUtils.gridDataFor((Control)this.link).widthHint = 350;
            for (SelectionListener pendingListener : this.pendingListeners) {
                this.link.addSelectionListener(pendingListener);
            }
            return this.link;
        }

        public void addLinkListener(SelectionListener listener) {
            if (this.link != null) {
                this.link.addSelectionListener(listener);
            } else {
                this.pendingListeners.add(listener);
            }
        }

        public void open(Point location) {
            this.location = location;
            this.open();
        }

        protected Point getInitialLocation(Point point) {
            return this.location == null ? point : this.location;
        }
    }

    private class Alert
    extends Composite {
        private final Link link;
        private final Label icon;
        private final ResourceManager imageManager;
        private final AlertPopup alertPopup;
        private final boolean dismissable;

        private Alert(AlertStyle style, Composite parent, boolean dismissable, String text, String explanation) {
            super(parent, 2048);
            this.dismissable = dismissable;
            this.setLayoutData(new GridData(768));
            this.setLayout((Layout)new GridLayout(dismissable ? 3 : 2, false));
            this.imageManager = new LocalResourceManager(JFaceResources.getResources());
            Color background = style.getColor((Device)this.getShell().getDisplay(), this.imageManager);
            this.setBackground(background);
            this.icon = new Label((Composite)this, 0x1000000);
            this.icon.setImage(style.getIcon(this.imageManager));
            this.icon.setLayoutData((Object)new GridData());
            this.icon.setBackground(background);
            this.link = new Link((Composite)this, 0);
            this.setText(text, explanation);
            this.link.setLayoutData((Object)new GridData(768));
            this.link.setBackground(background);
            this.alertPopup = new AlertPopup(this.getShell(), explanation);
            this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    Point cursorLocation = Display.getDefault().getCursorLocation();
                    Alert.this.alertPopup.open(new Point(cursorLocation.x + 20, cursorLocation.y));
                }
            });
            if (dismissable) {
                Label closeLabel = new Label((Composite)this, 0);
                SwtUtils.gridDataFor((Control)closeLabel).horizontalAlignment = 3;
                closeLabel.setImage(CloverPluginIcons.grabPluginImage(this.imageManager, "org.eclipse.ui", "icons/full/elcl16/close_view.gif"));
                closeLabel.setBackground(background);
                closeLabel.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent mouseEvent) {
                        SwtUtils.gridDataFor((Control)Alert.this).exclude = true;
                        Alert.this.setVisible(false);
                        ViewAlertContainer.this.updateContainerVisibility();
                    }
                });
            }
        }

        private void setText(String linkText, String explanation) {
            if (explanation != null && explanation.length() != 0) {
                this.link.setText(String.format("%s <a>More...</a>", linkText));
            } else {
                this.link.setText(linkText);
            }
        }

        public void addExplanationLinkListener(SelectionListener listener) {
            this.alertPopup.addLinkListener(listener);
        }

        public void dispose() {
            super.dispose();
            this.imageManager.dispose();
        }
    }

    private static enum AlertStyle {
        INFO(1, "icons/full/obj16/info_tsk.gif"){

            @Override
            public Color getColor(Device device, ResourceManager resourceManager) {
                try {
                    return resourceManager.createColor(new RGB(199, 235, 242));
                }
                catch (Exception e) {
                    CloverPlugin.logError("Unable to create info colour", e);
                    return device.getSystemColor(29);
                }
            }
        }
        ,
        WARNING(2, "icons/full/obj16/warn_tsk.gif"){

            @Override
            public Color getColor(Device device, ResourceManager resourceManager) {
                return device.getSystemColor(29);
            }
        }
        ,
        ERROR(4, "icons/full/obj16/error_tsk.gif"){

            @Override
            public Color getColor(Device device, ResourceManager resourceManager) {
                return device.getSystemColor(29);
            }
        };

        private final int status;
        private final String iconPath;

        private AlertStyle(int status, String iconPath) {
            this.status = status;
            this.iconPath = iconPath;
        }

        public abstract Color getColor(Device var1, ResourceManager var2);

        public int getStatus() {
            return this.status;
        }

        public Image getIcon(ResourceManager imageManager) {
            return CloverPluginIcons.grabPluginImage(imageManager, "org.eclipse.ui", this.iconPath);
        }
    }
}

