/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeItem;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.widgets.SelectionAwareCellRenderer;

public class LinkedProjectRenderer
extends SelectionAwareCellRenderer {
    public LinkedProjectRenderer(Composite rendered, ColumnCollectionSettings settings, ColumnDefinition column) {
        super(settings, column, rendered);
    }

    @Override
    public void startListening(Composite composite) {
        composite.addListener(42, this.paintListener);
        composite.addListener(40, this.eraseListener);
    }

    @Override
    public void stopListening(Composite composite) {
        composite.removeListener(42, this.paintListener);
        composite.removeListener(40, this.eraseListener);
    }

    @Override
    protected void paint(Event event) {
        if (this.forThisColumn(event) && event.item.getData() instanceof IProject) {
            TreeItem treeItem = (TreeItem)event.item;
            Rectangle imageBounds = treeItem.getImageBounds(0);
            Point textTopLeft = new Point(imageBounds.x + imageBounds.width + 5, imageBounds.y);
            Point textSize = event.gc.textExtent(((IProject)event.item.getData()).getName());
            event.gc.drawLine(textTopLeft.x, textTopLeft.y + textSize.y + 1, textTopLeft.x + textSize.x, textTopLeft.y + textSize.y + 1);
        }
    }
}

