/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.widgets;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;

public abstract class BaseListeningRenderer
implements ListeningRenderer {
    protected static final int MARGIN = 4;
    protected Composite rendered;
    protected int lastRowHeight;
    protected int lastRowX;
    protected int lastRowY;
    protected ColumnDefinition column;
    protected ColumnCollectionSettings settings;
    protected Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            BaseListeningRenderer.this.paint(event);
        }
    };
    protected Listener eraseListener = new Listener(){

        public void handleEvent(Event event) {
            BaseListeningRenderer.this.erase(event);
        }
    };

    public BaseListeningRenderer(Composite rendered, ColumnCollectionSettings settings, ColumnDefinition column) {
        this.rendered = rendered;
        this.settings = settings;
        this.column = column;
    }

    protected abstract void paint(Event var1);

    protected abstract void erase(Event var1);

    @Override
    public void startListening(Composite composite) {
        composite.addListener(42, this.paintListener);
        composite.addListener(40, this.eraseListener);
    }

    @Override
    public void stopListening(Composite composite) {
        composite.removeListener(42, this.paintListener);
        composite.removeListener(40, this.eraseListener);
    }

    protected boolean forSelection(Event event) {
        TreeItem[] selection = ((Tree)this.rendered).getSelection();
        return selection != null && selection.length == 1 && selection[0] == event.item;
    }

    protected int calcTargetColumnCurrentWidth(Event event) {
        return ((Tree)event.widget).getColumns()[event.index].getWidth();
    }

    protected boolean forThisColumn(Event event) {
        return event.index == this.settings.getVisibleColumnIndexFor(this.column);
    }
}

