/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testrunexplorer.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.openclover.eclipse.core.ui.SwtUtils;
import org.openclover.eclipse.core.views.ColumnDefinition;
import org.openclover.eclipse.core.views.testrunexplorer.TestRunExplorerViewSettings;
import org.openclover.eclipse.core.views.testrunexplorer.nodes.TestCaseNode;
import org.openclover.eclipse.core.views.widgets.BaseListeningRenderer;

public class TestStatusRenderer
extends BaseListeningRenderer {
    @Override
    protected void erase(Event event) {
        this.lastRowHeight = event.height;
        this.lastRowX = event.x;
        this.lastRowY = event.y;
        if (this.forThisColumn(event)) {
            if (this.isForTestCaseNode(event)) {
                Color oldBackground = event.gc.getBackground();
                Color newBackground = ((TestCaseNode)event.item.getData()).getStatus() == -1 ? event.gc.getDevice().getSystemColor(5) : event.gc.getDevice().getSystemColor(3);
                event.gc.setBackground(newBackground);
                event.gc.fillRectangle(event.x, event.y, event.width, event.height);
                event.gc.setBackground(oldBackground);
                event.detail &= 0xFFFFFFF7;
                event.detail &= 0xFFFFFFDF;
            } else if (this.forSelection(event)) {
                SwtUtils.renderSelectionBackground(event);
                event.detail &= 0xFFFFFFF7;
                event.detail &= 0xFFFFFFDF;
            }
        }
    }

    @Override
    protected void paint(Event event) {
        if (this.shouldRenderForeground(event)) {
            TestCaseNode testCaseNode;
            Object element = event.item.getData();
            Color foreground = event.gc.getDevice().getSystemColor(2);
            String label = element instanceof TestCaseNode ? ((testCaseNode = (TestCaseNode)element).getStatus() == -1 ? "PASS" : (testCaseNode.getStatus() == 0 ? "FAIL" : "ERROR")) : "";
            SwtUtils.drawText(label, event.gc, foreground, this.lastRowX, this.lastRowY, this.calcTargetColumnCurrentWidth(event), this.lastRowHeight, 4, 0x1000000);
        }
    }

    public TestStatusRenderer(TestRunExplorerViewSettings settings, ColumnDefinition column, Composite rendered) {
        super(rendered, settings.getTreeColumnSettings(), column);
    }

    private boolean isForTestCaseNode(Event event) {
        return event.item.getData() instanceof TestCaseNode;
    }

    private boolean shouldRenderForeground(Event event) {
        return this.forThisColumn(event) && event.item != null && this.isForTestCaseNode(event);
    }
}

