/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;

public abstract class TestContributionsWidgetSettings
implements IPersistable {
    public static final String COL_WIDTH_PREFIX = "column.width.";
    public static final String REVERSE_SORT = "reverse.sort";
    private static final String SORTED_COLUMN = "sorted.column";
    private int[] columnWidths = this.defaultColumnWidths();
    private int sortedColumn = 0;
    private boolean reverseSort = false;

    public TestContributionsWidgetSettings() {
        this(null);
    }

    public TestContributionsWidgetSettings(IMemento memento) {
        if (memento != null) {
            String reverseSort;
            Integer sortedColumn = memento.getInteger(this.prefix(SORTED_COLUMN));
            if (sortedColumn != null) {
                this.sortedColumn = sortedColumn;
            }
            if ((reverseSort = memento.getString(this.prefix(REVERSE_SORT))) != null) {
                this.reverseSort = Boolean.parseBoolean(reverseSort);
            }
            for (int i = 0; i < this.columnWidths.length; ++i) {
                Integer width = memento.getInteger(this.prefix(COL_WIDTH_PREFIX + i));
                if (width == null) continue;
                this.columnWidths[i] = width;
            }
        }
    }

    public void saveState(IMemento memento) {
        memento.putInteger(this.prefix(SORTED_COLUMN), this.sortedColumn);
        memento.putString(this.prefix(REVERSE_SORT), Boolean.toString(this.reverseSort));
        for (int i = 0; i < this.columnWidths.length; ++i) {
            memento.putInteger(this.prefix(COL_WIDTH_PREFIX + i), this.columnWidths[i]);
        }
    }

    public abstract String prefix(String var1);

    private int[] defaultColumnWidths() {
        return new int[]{300};
    }

    public void setColumnSize(int columnNumber, int width) {
        this.columnWidths[columnNumber] = width;
    }

    public int getColumnSize(int columnNumber) {
        return this.columnWidths[columnNumber];
    }

    public void sortOn(int columnNumber) {
        this.reverseSort ^= this.sortedColumn == columnNumber;
        this.sortedColumn = columnNumber;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public boolean isReverseSort() {
        return this.reverseSort;
    }
}

