/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.api.registry.ClassInfo;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.model.ModelUtils;
import org.openclover.eclipse.core.views.actions.OpenJavaEditorAction;
import org.openclover.eclipse.core.views.testcontributions.TestCaseInfoLabelProvider;
import org.openclover.eclipse.core.views.testcontributions.TestCaseInfoProvider;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsWidgetSettings;

public abstract class TestContributionsWidget
extends Composite
implements IDoubleClickListener,
IPersistable {
    protected Tree tree;
    protected TreeViewer testsViewer;
    protected ITextEditor editor;
    protected SelectionDispatchAction openAction;
    protected TestContributionsComputation testContributionsComputation;
    protected TestCaseInfoProvider provider;
    protected TestContributionsWidgetSettings settings;
    protected ViewPart viewPart;

    public TestContributionsWidget(TestContributionsWidgetSettings settings, ViewPart viewPart, Composite parent, int style, boolean showLabel, int treeStyle) {
        super(parent, style);
        this.settings = settings;
        this.viewPart = viewPart;
        this.setLayout((Layout)new GridLayout(1, false));
        if (showLabel) {
            Label label = new Label((Composite)this, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setText(this.getLabelTitle());
        }
        this.createTree(treeStyle);
        this.openAction = new OpenJavaEditorAction((IWorkbenchSite)viewPart.getSite());
        this.testsViewer = this.createTreeViewer();
        this.testContributionsComputation = this.createContributionsComputation();
        this.provider = this.createProvider();
        this.testsViewer.setContentProvider((IContentProvider)this.provider);
        this.testsViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.testsViewer.setAutoExpandLevel(3);
        this.testsViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.testsViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                int result = 0;
                result = object1 instanceof ClassInfo && object2 instanceof ClassInfo ? ((ClassInfo)object1).getQualifiedName().compareTo(((ClassInfo)object2).getQualifiedName()) : (object1 instanceof TestCaseInfo && object2 instanceof TestCaseInfo ? FixedSourceRegion.SOURCE_ORDER_COMP.compare(((TestCaseInfo)object1).getSourceMethod(), ((TestCaseInfo)object2).getSourceMethod()) : 0);
                return (TestContributionsWidget.this.settings.isReverseSort() ? -1 : 1) * result;
            }
        });
    }

    protected TestCaseInfoProvider createProvider() {
        return new TestCaseInfoProvider();
    }

    protected TestCaseInfoLabelProvider createLabelProvider() {
        return new TestCaseInfoLabelProvider();
    }

    public void saveState(IMemento memento) {
        this.settings.saveState(memento);
    }

    public void setEditor(ITextEditor editor) {
        this.editor = editor;
    }

    public IJavaProject getJavaProjectForEditor() {
        IJavaElement element = this.editor == null ? null : JavaUI.getEditorInputJavaElement((IEditorInput)this.editor.getEditorInput());
        return element == null ? null : element.getJavaProject();
    }

    protected void jumpToSource(IStructuredSelection selection) {
        try {
            Object cloverElementSelected = selection.getFirstElement();
            IJavaProject javaProject = this.getJavaProjectForEditor();
            IType javaElement = null;
            if (cloverElementSelected instanceof ClassInfo) {
                javaElement = ModelUtils.findTestCaseClass(-1, javaProject, (ClassInfo)cloverElementSelected);
            } else if (cloverElementSelected instanceof TestCaseInfo) {
                javaElement = ModelUtils.findTestCaseMethod(-1, javaProject, (TestCaseInfo)cloverElementSelected);
            }
            if (javaElement != null) {
                this.openAction.run((IStructuredSelection)new StructuredSelection((Object)javaElement));
            }
        }
        catch (JavaModelException e) {
            CloverPlugin.logError("Unable to open test case class/method", e);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.tree.setEnabled(enabled);
    }

    protected abstract String getLabelTitle();

    protected void createTree(int treeStyle) {
        this.tree = new Tree((Composite)this, treeStyle);
        this.tree.setHeaderVisible(true);
        this.tree.setLayoutData((Object)new GridData(1808));
        final TreeColumn column = new TreeColumn(this.tree, 0);
        column.setText("Test");
        column.setWidth(this.settings.getColumnSize(0));
        this.tree.setSortColumn(column);
        this.tree.setSortDirection(this.settings.isReverseSort() ? 128 : 1024);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TestContributionsWidget.this.settings.sortOn(0);
                TestContributionsWidget.this.tree.setSortColumn(column);
                TestContributionsWidget.this.tree.setSortDirection(TestContributionsWidget.this.settings.isReverseSort() ? 128 : 1024);
                TestContributionsWidget.this.testsViewer.refresh();
            }
        });
    }

    protected abstract TreeViewer createTreeViewer();

    protected abstract TestContributionsComputation createContributionsComputation();

    public void doubleClick(DoubleClickEvent event) {
        if (!event.getSelection().isEmpty() && event.getSelection() instanceof IStructuredSelection) {
            this.jumpToSource((IStructuredSelection)event.getSelection());
        }
    }
}

