/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationModel;

public abstract class TestContributionsComputation
extends Job {
    private static final QualifiedName CONTRIBUTIONS = new QualifiedName("org.openclover.eclipse.core", "TestContributionsAtCursor");
    protected static final QualifiedName DATABASE_MODEL = new QualifiedName("org.openclover.eclipse.core", "TestContributionsDatabaseModel");
    protected static final QualifiedName COVERAGE_ANNOTATION_MODEL = new QualifiedName("org.openclover.eclipse.core", "TestContributionsCoverageAnnotationModel");
    protected static final QualifiedName INPUT_CHANGED = new QualifiedName("org.openclover.eclipse.core", "TestContributionsInputChanged");

    public TestContributionsComputation(String name) {
        super(name);
        this.setPriority(50);
        this.setUser(false);
        this.setSystem(true);
        this.setProperty(INPUT_CHANGED, Boolean.TRUE);
    }

    public Set<TestCaseInfo> getTestCases() {
        return (Set)this.getProperty(CONTRIBUTIONS);
    }

    protected void setTestCases(Set<TestCaseInfo> testCases) {
        this.setProperty(CONTRIBUTIONS, testCases);
    }

    protected DatabaseModel getDatabaseModel() {
        return (DatabaseModel)this.getProperty(DATABASE_MODEL);
    }

    protected CoverageAnnotationModel getCoverageAnnotationModel() {
        return (CoverageAnnotationModel)this.getProperty(COVERAGE_ANNOTATION_MODEL);
    }

    protected DatabaseModel databaseModelForEditor(ITextEditor editor) {
        IJavaElement element;
        IJavaElement iJavaElement = element = editor == null ? null : JavaUI.getEditorInputJavaElement((IEditorInput)editor.getEditorInput());
        if (CloverPlugin.getInstance().isInWorkingSetMode() && !CloverPlugin.getInstance().getCloverWorkingSet().includesCU((IAdaptable)element)) {
            return null;
        }
        CloverProject cloverProject = element != null ? (CloverProject)element.getAdapter(CloverProject.class) : null;
        return cloverProject == null ? null : cloverProject.getModel();
    }

    public boolean isInputChanged() {
        return (Boolean)this.getProperty(INPUT_CHANGED);
    }

    protected void setInputChanged(boolean changed) {
        this.setProperty(INPUT_CHANGED, changed);
    }

    protected void setCoverageAnnotationModel(CoverageAnnotationModel newCoverageAnnotationModel) {
        this.setProperty(COVERAGE_ANNOTATION_MODEL, newCoverageAnnotationModel);
    }

    protected void setDatabaseModel(DatabaseModel newDatabaseModel) {
        this.setProperty(DATABASE_MODEL, newDatabaseModel);
    }

    public abstract void prime(ITextEditor var1);
}

