/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.testcontributions;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.DatabaseModel;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationFilter;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationModel;
import org.openclover.eclipse.core.views.testcontributions.AllTestCaseInfoProvider;
import org.openclover.eclipse.core.views.testcontributions.TestContributionsComputation;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class AllTestContributionsComputation
extends TestContributionsComputation {
    private static final QualifiedName COMPILATION_UNIT = new QualifiedName("org.openclover.eclipse.core", "TestContributionsCompilationUnit");
    private static final QualifiedName CHECKED_TEST_CASES_AND_CLASSES = new QualifiedName("org.openclover.eclipse.core", "TestContributionsCheckedTestCasesAndClasses");

    public AllTestContributionsComputation() {
        super("Syncing test contributions for open editor");
    }

    @Override
    public void prime(ITextEditor editor) {
        DatabaseModel oldDatabaseModel = this.getDatabaseModel();
        DatabaseModel newDatabaseModel = this.databaseModelForEditor(editor);
        CoverageAnnotationModel oldAnnotationModel = this.getCoverageAnnotationModel();
        CoverageAnnotationModel newAnnotationModel = CoverageAnnotationModel.getModel(editor);
        ICompilationUnit oldCompilationUnit = this.getCompilationUnit();
        ICompilationUnit newCompilationUnit = this.compilationUnitForEditor(editor);
        if (oldAnnotationModel != newAnnotationModel || oldDatabaseModel != newDatabaseModel) {
            this.setInputChanged(true);
            this.setDatabaseModel(newDatabaseModel);
            this.setCoverageAnnotationModel(newAnnotationModel);
            this.setCompilationUnit(newCompilationUnit);
        } else {
            this.setInputChanged(false);
        }
    }

    private ICompilationUnit compilationUnitForEditor(ITextEditor editor) {
        IJavaElement javaElement = editor == null ? null : JavaUI.getEditorInputJavaElement((IEditorInput)editor.getEditorInput());
        return javaElement instanceof ICompilationUnit ? (ICompilationUnit)javaElement : null;
    }

    private void setCompilationUnit(ICompilationUnit compilationUnit) {
        this.setProperty(COMPILATION_UNIT, compilationUnit);
    }

    private ICompilationUnit getCompilationUnit() {
        return (ICompilationUnit)this.getProperty(COMPILATION_UNIT);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            if (this.isInputChanged()) {
                this.setTestCases(Collections.emptySet());
                this.setCheckedTestCasesAndClasses(Collections.emptySet());
                CoverageAnnotationModel annotationModel = this.getCoverageAnnotationModel();
                DatabaseModel databaseModel = this.getDatabaseModel();
                ICompilationUnit cu = this.getCompilationUnit();
                if (annotationModel == null) {
                    this.clearTestCases();
                } else if (databaseModel != null && cu != null) {
                    this.updateTestCases(cu);
                }
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to calculate file-based test contributions", e);
        }
        return Status.OK_STATUS;
    }

    private void updateTestCases(ICompilationUnit cu) {
        FullFileInfo fileInfo;
        CloverDatabase database;
        CloverProject project = (CloverProject)cu.getAdapter(CloverProject.class);
        if (project != null && (database = project.getModel().getDatabase()) != null && (fileInfo = (FullFileInfo)MetricsScope.FULL.getHasMetricsFor(cu, FullFileInfo.class)) != null) {
            HashSet<TestCaseInfo> allTests = Sets.newHashSet();
            HashSet<TestCaseInfo> checkedTests = Sets.newHashSet();
            CoverageAnnotationFilter.TestFilter excludedTestNames = CoverageAnnotationFilter.TestFilter.loadFor(cu.getResource(), CoverageAnnotationFilter.EXCLUDED_TEST_NAMES);
            Set<TestCaseInfo> testHits = database.getTestHits(fileInfo);
            Iterator<TestCaseInfo> iterator = testHits.iterator();
            while (iterator.hasNext()) {
                TestCaseInfo testCase = iterator.next();
                if (testCase.isResolved() || testCase.resolve(MetricsScope.FULL.getProjectInfoFor(database))) {
                    allTests.add(testCase);
                    if (excludedTestNames.matches(testCase)) continue;
                    checkedTests.add(testCase);
                    continue;
                }
                iterator.remove();
            }
            this.setTestCases(allTests);
            this.setCheckedTestCasesAndClasses(AllTestContributionsComputation.computeCheckedTestCasesAndClasses(allTests, checkedTests));
        }
    }

    private void clearTestCases() {
        this.setTestCases(Collections.emptySet());
        this.setCheckedTestCasesAndClasses(Collections.singleton(AllTestCaseInfoProvider.ALL_TEST_CASES));
    }

    public static Set computeCheckedTestCasesAndClasses(Set<TestCaseInfo> allTestCases, Set<TestCaseInfo> checkedTestCases) {
        HashSet<TestCaseInfo> checkedTestCasesAndClasses = Sets.newHashSet(checkedTestCases);
        HashMap allTestClassToTestCases = Maps.newHashMap();
        for (TestCaseInfo testCaseInfo : allTestCases) {
            HashSet testCasesForClass = (HashSet)allTestClassToTestCases.get(testCaseInfo.getRuntimeType());
            if (testCasesForClass == null) {
                testCasesForClass = Sets.newHashSet();
                allTestClassToTestCases.put(testCaseInfo.getRuntimeType(), testCasesForClass);
            }
            testCasesForClass.add(testCaseInfo);
        }
        HashMap checkedTestClassToTestCases = new HashMap();
        for (TestCaseInfo testCase : checkedTestCases) {
            HashSet testCasesForClass = (HashSet)checkedTestClassToTestCases.get(testCase.getRuntimeType());
            if (testCasesForClass == null) {
                testCasesForClass = Sets.newHashSet();
                checkedTestClassToTestCases.put(testCase.getRuntimeType(), testCasesForClass);
            }
            testCasesForClass.add(testCase);
        }
        for (Map.Entry entry : checkedTestClassToTestCases.entrySet()) {
            if (((Collection)entry.getValue()).size() != ((Collection)allTestClassToTestCases.get(entry.getKey())).size()) continue;
            checkedTestCasesAndClasses.add((TestCaseInfo)entry.getKey());
        }
        if (allTestCases.size() == checkedTestCases.size()) {
            checkedTestCasesAndClasses.add((TestCaseInfo)AllTestCaseInfoProvider.ALL_TEST_CASES);
        }
        return checkedTestCasesAndClasses;
    }

    private void setCheckedTestCasesAndClasses(Set tests) {
        this.setProperty(CHECKED_TEST_CASES_AND_CLASSES, tests);
    }

    public Set getCheckedTestCasesAndClasses() {
        return (Set)this.getProperty(CHECKED_TEST_CASES_AND_CLASSES);
    }
}

