/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.util.Lists;

public class TypeToInnerTypeAndMethodRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            ArrayList<IType> types = Lists.newArrayList(((IType)object).getTypes());
            Iterator iter = types.iterator();
            while (iter.hasNext()) {
                IType type = (IType)iter.next();
                if (!type.isAnonymous()) continue;
                iter.remove();
            }
            IMethod[] methods = ((IType)object).getMethods();
            ArrayList<Object> children = new ArrayList<Object>(types.size() + methods.length);
            children.addAll(types);
            children.addAll(Arrays.asList(methods));
            return filter.perform(children);
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to collect inner-types in type " + object, e);
            return new Object[0];
        }
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IType;
    }
}

