/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.PkgFragRootToPkgFragRelationship;

public class ProjToPkgFragRootRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            CloverProject cloverProject = CloverProject.getFor((IProject)object);
            if (cloverProject != null && cloverProject.getModel().isLoaded()) {
                IPackageFragmentRoot[] roots = cloverProject.getJavaProject().getPackageFragmentRoots();
                ArrayList<Object> sourceRoots = new ArrayList<Object>(roots.length);
                PkgFragRootToPkgFragRelationship pkgFragRootToPkgFrag = new PkgFragRootToPkgFragRelationship();
                for (IPackageFragmentRoot root : roots) {
                    if (root.getKind() != 1) continue;
                    if (root.getPath() == root.getJavaProject().getPath()) {
                        sourceRoots.addAll(Arrays.asList(((NodeRelationship)pkgFragRootToPkgFrag).getChildren(root, filter)));
                        break;
                    }
                    if (!((NodeRelationship)pkgFragRootToPkgFrag).hasChildren(root, filter).booleanValue()) continue;
                    sourceRoots.add(root);
                }
                return filter.perform(sourceRoots);
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for project " + object, e);
        }
        return new Object[0];
    }

    @Override
    public Boolean hasChildren(Object object, NodeRelationshipFilter filter) {
        try {
            CloverProject cloverProject = CloverProject.getFor((IProject)object);
            if (cloverProject != null && cloverProject.getModel().isLoaded()) {
                IPackageFragmentRoot[] roots = cloverProject.getJavaProject().getPackageFragmentRoots();
                PkgFragRootToPkgFragRelationship pkgFragRootToPkgFrag = new PkgFragRootToPkgFragRelationship();
                for (IPackageFragmentRoot root : roots) {
                    if (root.getKind() != 1) continue;
                    if (root.getPath() == root.getJavaProject().getPath()) {
                        return ((NodeRelationship)pkgFragRootToPkgFrag).hasChildren(root, filter);
                    }
                    if (!((NodeRelationship)pkgFragRootToPkgFrag).hasChildren(root, filter).booleanValue() || !filter.accept(root)) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for project " + object, e);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IProject;
    }
}

