/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.nodes.LeafPackageFragmentNode;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.util.Lists;
import org.openclover.util.Maps;

public class ProjToLeafPkgFragRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            CloverProject cloverProject = CloverProject.getFor((IProject)object);
            if (cloverProject != null && cloverProject.getModel().isLoaded()) {
                IJavaProject javaProject = cloverProject.getJavaProject();
                HashMap pkgNamesToFragments = Maps.newHashMap();
                for (IPackageFragmentRoot root : Arrays.asList(javaProject.getPackageFragmentRoots())) {
                    IJavaElement[] packageFragments;
                    if (root.getKind() != 1) continue;
                    for (IJavaElement packageFragment : packageFragments = root.getChildren()) {
                        if (!(packageFragment instanceof IPackageFragment) || ((IPackageFragment)packageFragment).getCompilationUnits().length <= 0) continue;
                        LinkedHashSet<IPackageFragment> fragments = (LinkedHashSet<IPackageFragment>)pkgNamesToFragments.get(packageFragment.getElementName());
                        if (fragments == null) {
                            fragments = new LinkedHashSet<IPackageFragment>();
                            pkgNamesToFragments.put(packageFragment.getElementName(), fragments);
                        }
                        fragments.add((IPackageFragment)packageFragment);
                    }
                }
                LinkedList multis = Lists.newLinkedList();
                for (Map.Entry entry : pkgNamesToFragments.entrySet()) {
                    String name = (String)entry.getKey();
                    Set fragments = (Set)entry.getValue();
                    if (fragments.isEmpty()) continue;
                    multis.add(new LeafPackageFragmentNode(name, fragments));
                }
                return filter.perform(multis);
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for parent " + object, e);
        }
        return new Object[0];
    }

    @Override
    public Boolean hasChildren(Object object, NodeRelationshipFilter filter) {
        try {
            CloverProject cloverProject = CloverProject.getFor((IProject)object);
            if (cloverProject != null && cloverProject.getModel().isLoaded()) {
                IJavaProject javaProject = cloverProject.getJavaProject();
                List<IPackageFragmentRoot> fragmentRoots = Arrays.asList(javaProject.getPackageFragmentRoots());
                for (IPackageFragmentRoot root : fragmentRoots) {
                    IJavaElement[] packageFragments;
                    if (root.getKind() != 1) continue;
                    for (IJavaElement packageFragment : packageFragments = root.getChildren()) {
                        if (!(packageFragment instanceof IPackageFragment) || ((IPackageFragment)packageFragment).getCompilationUnits().length <= 0 || !filter.accept(packageFragment)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for parent " + object, e);
        }
        return false;
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IProject;
    }
}

