/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.TreePackageFragmentNode;

public class PkgFragRootToTreePkgFragNodeRelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)object;
            IJavaElement[] children = root.getChildren();
            ArrayList<TreePackageFragmentNode> packageFragments = new ArrayList<TreePackageFragmentNode>(children.length);
            for (IJavaElement child : children) {
                if (!(child instanceof IPackageFragment) || !this.isTopLevelPackage((IPackageFragment)child)) continue;
                packageFragments.add(new TreePackageFragmentNode(child.getElementName(), Collections.singleton((IPackageFragment)child)));
            }
            return filter.perform(packageFragments);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to retrieve children for package fragment " + object, e);
            return new Object[0];
        }
    }

    private boolean isTopLevelPackage(IPackageFragment packageFragment) throws JavaModelException {
        if (packageFragment.isDefaultPackage()) {
            return packageFragment.getCompilationUnits().length > 0;
        }
        return !packageFragment.getElementName().contains(".") && (packageFragment.hasSubpackages() || packageFragment.getCompilationUnits().length > 0);
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof IPackageFragmentRoot;
    }
}

