/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.PackageFragmentAdapter;
import org.openclover.eclipse.core.views.nodes.PackageFragmentNode;
import org.openclover.eclipse.core.views.nodes.TreePackageFragmentNode;
import org.openclover.util.Lists;
import org.openclover.util.Maps;
import org.openclover.util.Sets;

public class PhysicalTreePkgFragNodeToTreeMultiPkgFragNodeAndCURelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            LinkedList children = Lists.newLinkedList();
            LinkedList CUs = Lists.newLinkedList();
            TreePackageFragmentNode pkgFragNode = (TreePackageFragmentNode)object;
            final String pkgName = pkgFragNode.getElementName();
            IJavaProject javaProject = pkgFragNode.toJavaElement().getJavaProject();
            HashMap pkgNamesToFragments = Maps.newHashMap();
            for (IPackageFragmentRoot iPackageFragmentRoot : Arrays.asList(javaProject.getPackageFragmentRoots())) {
                IJavaElement[] siblingPkgs;
                IPackageFragment pkgFragmentForRoot;
                if (iPackageFragmentRoot.getKind() != 1 || (pkgFragmentForRoot = iPackageFragmentRoot.getPackageFragment(pkgName)) == null) continue;
                if (pkgFragmentForRoot.exists()) {
                    CUs.addAll(Arrays.asList(pkgFragmentForRoot.getCompilationUnits()));
                }
                int subPkgCount = pkgName.split("\\.").length;
                for (IJavaElement siblingPkg : siblingPkgs = iPackageFragmentRoot.getChildren()) {
                    if (!(siblingPkg instanceof IPackageFragment) || siblingPkg.getElementName().indexOf(pkgFragmentForRoot.getElementName() + ".") != 0 || siblingPkg.getElementName().split("\\.").length != subPkgCount + 1) continue;
                    HashSet pkgFragmentsForName = (HashSet)pkgNamesToFragments.get(siblingPkg.getElementName());
                    if (pkgFragmentsForName == null) {
                        pkgFragmentsForName = Sets.newHashSet();
                        pkgNamesToFragments.put(siblingPkg.getElementName(), pkgFragmentsForName);
                    }
                    pkgFragmentsForName.add(new PackageFragmentAdapter((IPackageFragment)siblingPkg){

                        @Override
                        public String getElementName() {
                            return super.getElementName().substring(pkgName.length() + 1);
                        }
                    });
                }
            }
            for (Map.Entry entry : pkgNamesToFragments.entrySet()) {
                children.add(new TreePackageFragmentNode((String)entry.getKey(), (Set)entry.getValue()));
            }
            children.addAll(CUs);
            return filter.perform(children);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to meta-collect compilation units of package fragment " + object, e);
            return new Object[0];
        }
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof PackageFragmentNode;
    }
}

