/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.openclover.eclipse.core.views.nodes.JavaElementNode;

public abstract class PackageFragmentNode
extends JavaElementNode {
    protected String name;
    protected Set<IPackageFragment> packageFragments;

    public PackageFragmentNode(String name, Set<? extends IPackageFragment> fragments) {
        this.name = name;
        this.packageFragments = Collections.unmodifiableSet(new LinkedHashSet<IPackageFragment>(fragments));
    }

    public Set<IPackageFragment> getPackageFragments() {
        return this.packageFragments;
    }

    @Override
    public IJavaElement toJavaElement() {
        return this.packageFragments.isEmpty() ? null : (IJavaElement)this.packageFragments.iterator().next();
    }

    public String getElementName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageFragmentNode that = (PackageFragmentNode)o;
        return Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        return result;
    }
}

