/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.nodes;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.views.nodes.NodeRelationship;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;
import org.openclover.eclipse.core.views.nodes.PackageFragmentAdapter;
import org.openclover.eclipse.core.views.nodes.TreePackageFragmentNode;
import org.openclover.util.Lists;

public class LogicalTreePkgFragNodeToTreeMultiPkgFragNodeAndCURelationship
extends NodeRelationship {
    @Override
    public Object[] getChildren(Object object, NodeRelationshipFilter filter) {
        try {
            LinkedList children = Lists.newLinkedList();
            IPackageFragment pkg = (IPackageFragment)((TreePackageFragmentNode)object).toJavaElement();
            pkg = pkg instanceof PackageFragmentAdapter ? (IPackageFragment)((PackageFragmentAdapter)pkg).getAdaptee() : pkg;
            final String pkgName = pkg.getElementName();
            int subPkgCount = pkgName.split("\\.").length;
            if (pkg.exists()) {
                if (!pkg.isDefaultPackage()) {
                    IJavaElement[] siblingPkgs;
                    for (IJavaElement siblingPkg : siblingPkgs = ((IPackageFragmentRoot)pkg.getParent()).getChildren()) {
                        if (!(siblingPkg instanceof IPackageFragment) || siblingPkg == pkg || siblingPkg.getElementName().indexOf(pkg.getElementName()) != 0 || siblingPkg.getElementName().split("\\.").length != subPkgCount + 1) continue;
                        children.add(new TreePackageFragmentNode(siblingPkg.getElementName(), Collections.singleton(new PackageFragmentAdapter((IPackageFragment)siblingPkg){

                            @Override
                            public String getElementName() {
                                return super.getElementName().substring(pkgName.length() + 1);
                            }
                        })));
                    }
                }
                children.addAll(Arrays.asList(pkg.getCompilationUnits()));
            }
            return filter.perform(children);
        }
        catch (Exception e) {
            CloverPlugin.logError("Unable to meta-collect compilation units of package fragment " + object, e);
            return new Object[0];
        }
    }

    @Override
    public boolean includes(Object object) {
        return object instanceof TreePackageFragmentNode;
    }
}

