/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.dashboard;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.CloverException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.builder.PathUtils;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.eclipse.core.views.dashboard.DashboardGenerator;
import org.openclover.eclipse.core.views.dashboard.DashboardLocationListener;

public class DashboardView
extends ViewPart
implements ISelectionListener,
DatabaseChangeListener {
    public static final String ID = "org.openclover.eclipse.core.views.dashboard";
    private static final String EMPTY_DASHBOARD = "<body style=\"font-family:verdana,arial,sans-serif; font-size:12px;\">Please select a Cloverized project.</body>";
    private Browser browser;
    CloverProject lastSelectedProject;

    public void createPartControl(Composite parent) {
        this.browser = new Browser(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.browser);
        this.browser.addLocationListener((LocationListener)new DashboardLocationListener(this));
        this.browser.setText(EMPTY_DASHBOARD);
        this.selectionChanged(null, this.getSite().getWorkbenchWindow().getSelectionService().getSelection());
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this);
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String projectName;
        super.init(site, memento);
        String string = projectName = memento != null ? memento.getString("lastSelectedProject") : null;
        if (projectName != null) {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            try {
                this.lastSelectedProject = CloverProject.getFor(project);
            }
            catch (CoreException e) {
                CloverPlugin.logWarning("Exception while restoring Dashboard view", e);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        if (this.lastSelectedProject != null) {
            memento.putString("lastSelectedProject", this.lastSelectedProject.getName());
        }
    }

    public void dispose() {
        CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this);
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    void projectSelected(IProject project) throws CloverException, IOException, Exception {
        CloverProject cloverProject = CloverProject.getFor(project);
        if (cloverProject != null && cloverProject != this.lastSelectedProject) {
            this.generateReport(null, cloverProject);
        }
    }

    protected void generateReport(IProgressMonitor monitor, CloverProject cloverProject) throws Exception, CloverException, IOException {
        CloverDatabase database;
        if (cloverProject != null && (database = cloverProject.getModel().getDatabase()) != null) {
            DashboardGenerator dashboardGenerator = new DashboardGenerator(database, this.ensureReportFolderCreated(cloverProject));
            dashboardGenerator.execute();
            this.browser.setUrl(dashboardGenerator.getDashboardURL());
            this.lastSelectedProject = cloverProject;
        } else {
            this.browser.setText(EMPTY_DASHBOARD);
        }
    }

    protected File ensureReportFolderCreated(CloverProject project) throws CoreException {
        IFolder folder = project.getReportDir();
        if (!folder.exists()) {
            PathUtils.makeDerivedFolder(folder);
        }
        return folder.getLocation().toFile();
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Object firstElement;
        if (selection instanceof IStructuredSelection && (firstElement = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)firstElement;
            IResource resource = (IResource)adaptable.getAdapter(IResource.class);
            if (resource != null) {
                try {
                    this.projectSelected(resource.getProject());
                }
                catch (Exception e) {
                    CloverPlugin.logError("Error creating the dashboard", e);
                }
            } else {
                IJavaElement element = (IJavaElement)adaptable.getAdapter(IJavaElement.class);
                IJavaProject javaProject = element != null ? element.getJavaProject() : null;
                try {
                    this.projectSelected(javaProject != null ? javaProject.getProject() : null);
                }
                catch (Exception e) {
                    CloverPlugin.logError("Error creating the dashboard", e);
                }
            }
        }
    }

    @Override
    public void databaseChanged(final DatabaseChangeEvent event) {
        this.browser.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (event.isApplicableTo(DashboardView.this.lastSelectedProject) && event.isSubstantiveProjectChange() || event.isForWorkspace()) {
                    try {
                        DashboardView.this.generateReport(null, DashboardView.this.lastSelectedProject);
                    }
                    catch (Exception e) {
                        CloverPlugin.logWarning("Problem generating Dashboard report", e);
                    }
                }
            }
        });
    }
}

