/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer.widgets;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.ui.SwtUtils;

public class InstallationSettingsDialog
extends PopupDialog {
    private final Point location;
    private Button apply;
    private Combo refreshIntervalCombo;
    private Button refreshButton;
    private Button aggregateCoverageButton;
    private Button trackPerTestCoverageButton;
    private Button inMemPerTestCoverageButton;

    public InstallationSettingsDialog(Shell parent, Point location) {
        super(parent, 4, true, false, false, false, false, "Workspace Settings", null);
        this.location = location;
    }

    protected Control createDialogArea(Composite composite) {
        Composite parent = new Composite(composite, 0);
        parent.setLayout((Layout)new GridLayout(2, false));
        SelectionAdapter onChangeEnableApply = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstallationSettingsDialog.this.apply.setEnabled(true);
            }
        };
        this.aggregateCoverageButton = new Button(parent, 32);
        SwtUtils.gridDataFor((Control)this.aggregateCoverageButton).horizontalSpan = 2;
        this.aggregateCoverageButton.setText("Aggregate coverage generated since the last clean build");
        this.aggregateCoverageButton.setToolTipText("If enabled, Clover will aggregate all coverage generated from all tests run since the last clean build (this is useful when you want to continually track how your total coverage changes as you change your code and re-run tests)\n\nIf disabled, Clover will only load coverage generated since the last source change (this is useful when you are focussing on a single test and wish to interatively build out unit tests to increase its coverage)");
        this.aggregateCoverageButton.setSelection(CloverPlugin.getInstance().getInstallationSettings().isAggregatingCoverage());
        this.aggregateCoverageButton.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.trackPerTestCoverageButton = new Button(parent, 32);
        SwtUtils.gridDataFor((Control)this.trackPerTestCoverageButton).horizontalSpan = 2;
        this.trackPerTestCoverageButton.setText("Track per-test coverage");
        this.trackPerTestCoverageButton.setToolTipText("Enabled Clover to track the coverage generated by each test in your project. You can disable this setting if you only care about total coverage, and not per-test coverage. For per-test coverage to operate correctly, you must ensure your JUnit or TestNG tests are instrumented by Clover.");
        this.trackPerTestCoverageButton.setSelection(CloverPlugin.getInstance().getInstallationSettings().isTrackingPerTestCoverage());
        this.trackPerTestCoverageButton.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.trackPerTestCoverageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstallationSettingsDialog.this.inMemPerTestCoverageButton.setEnabled(InstallationSettingsDialog.this.trackPerTestCoverageButton.getSelection());
            }
        });
        this.inMemPerTestCoverageButton = new Button(parent, 32);
        SwtUtils.gridDataFor((Control)this.inMemPerTestCoverageButton).horizontalSpan = 2;
        this.inMemPerTestCoverageButton.setText("Keep per-test coverage data fully in memory");
        this.inMemPerTestCoverageButton.setToolTipText("If enabled, per-test coverage data is loaded into memory which may speed performance of certain operations but will consume more memory. This is only recommended if your Clover-enabled projects are small in size and small in number.");
        this.inMemPerTestCoverageButton.setSelection(CloverPlugin.getInstance().getInstallationSettings().isPerTestCoverageInMemory());
        this.inMemPerTestCoverageButton.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.inMemPerTestCoverageButton.setEnabled(this.trackPerTestCoverageButton.getSelection());
        this.refreshButton = new Button(parent, 32);
        this.refreshButton.setText("Look for updated coverage every:");
        this.refreshButton.setToolTipText("Tells Clover whether it should look for new coverage generated by your tests or by running your application. If disabled, to see updated coverage you must select your project in the Coverage Explorer and manually reload coverage (via the button in the Coverage Explorer toolbar or via the context menu).");
        this.refreshButton.setSelection(CloverPlugin.getInstance().getInstallationSettings().isAutoRefreshingCoverage());
        this.refreshButton.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstallationSettingsDialog.this.refreshIntervalCombo.setEnabled(InstallationSettingsDialog.this.refreshButton.getSelection());
            }
        });
        this.refreshIntervalCombo = new Combo(parent, 8);
        this.refreshIntervalCombo.setItems(new String[]{CloverEclipsePluginMessages.TWO_SECONDS(), CloverEclipsePluginMessages.FIVE_SECONDS(), CloverEclipsePluginMessages.TEN_SECONDS(), CloverEclipsePluginMessages.TWENTY_SECONDS()});
        long refreshPeriod = CloverPlugin.getInstance().getInstallationSettings().getCoverageRefreshPeriod();
        if (refreshPeriod == 5000L) {
            this.refreshIntervalCombo.select(1);
        } else if (refreshPeriod == 10000L) {
            this.refreshIntervalCombo.select(2);
        } else if (refreshPeriod == 20000L) {
            this.refreshIntervalCombo.select(3);
        } else {
            this.refreshIntervalCombo.select(0);
        }
        this.refreshIntervalCombo.addSelectionListener((SelectionListener)onChangeEnableApply);
        this.apply = new Button(parent, 0);
        this.apply.setText("Apply");
        SwtUtils.gridDataFor((Control)this.apply).horizontalSpan = 2;
        SwtUtils.gridDataFor((Control)this.apply).horizontalAlignment = 3;
        this.apply.setEnabled(false);
        this.apply.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                boolean needsReload = CloverPlugin.getInstance().getInstallationSettings().isAggregatingCoverage() ^ InstallationSettingsDialog.this.aggregateCoverageButton.getSelection() || CloverPlugin.getInstance().getInstallationSettings().isTrackingPerTestCoverage() ^ InstallationSettingsDialog.this.trackPerTestCoverageButton.getSelection() || CloverPlugin.getInstance().getInstallationSettings().isPerTestCoverageInMemory() ^ InstallationSettingsDialog.this.inMemPerTestCoverageButton.getSelection();
                CloverPlugin.getInstance().getInstallationSettings().setAggregateCoverage(InstallationSettingsDialog.this.aggregateCoverageButton.getSelection());
                CloverPlugin.getInstance().getInstallationSettings().setTrackingPerTestCoverage(InstallationSettingsDialog.this.trackPerTestCoverageButton.getSelection());
                CloverPlugin.getInstance().getInstallationSettings().setAutoRefreshingCoverage(InstallationSettingsDialog.this.refreshButton.getSelection());
                CloverPlugin.getInstance().getInstallationSettings().setPerTestCoverageInMemory(InstallationSettingsDialog.this.inMemPerTestCoverageButton.getSelection());
                long refreshPeriod = 0L;
                switch (InstallationSettingsDialog.this.refreshIntervalCombo.getSelectionIndex()) {
                    case 1: {
                        refreshPeriod = 5000L;
                        break;
                    }
                    case 2: {
                        refreshPeriod = 10000L;
                        break;
                    }
                    case 3: {
                        refreshPeriod = 20000L;
                        break;
                    }
                    default: {
                        refreshPeriod = 2000L;
                    }
                }
                CloverPlugin.getInstance().getInstallationSettings().setValue("coverage_refresh", (int)refreshPeriod);
                InstallationSettingsDialog.this.apply.setEnabled(false);
                InstallationSettingsDialog.this.close();
                if (needsReload) {
                    CloverProject.refreshAllModels(false, true);
                }
            }
        });
        return parent;
    }

    protected Point getInitialLocation(Point point) {
        return this.location;
    }
}

