/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.coverageexplorer;

import com.atlassian.clover.registry.metrics.BlockMetrics;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.CloveredWorkspaceProvider;
import org.openclover.eclipse.core.views.TypeUtils;
import org.openclover.eclipse.core.views.WorkingSetNodeFilter;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageView;
import org.openclover.eclipse.core.views.coverageexplorer.CoverageViewSettings;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;

public class CoverageProvider
extends CloveredWorkspaceProvider {
    public CoverageProvider(CoverageView part, CoverageViewSettings settings) {
        super(part, settings);
    }

    @Override
    protected NodeRelationshipFilter getFilter() {
        return new WorkingSetNodeFilter(){

            @Override
            public boolean accept(Object element) {
                return super.accept(element) && this.inMetricsScope(element) && this.inMetricsRange(element) || this.isMethod(element) || this.isCloverProjectAndModelNotYetLoaded(element);
            }

            private boolean isCloverProjectAndModelNotYetLoaded(Object element) {
                if (element instanceof IProject) {
                    try {
                        CloverProject project = CloverProject.getFor((IProject)element);
                        return project != null && !project.getModel().isLoaded();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return false;
            }

            private boolean isMethod(Object element) {
                return element instanceof IMethod;
            }

            private boolean inMetricsScope(Object element) {
                try {
                    return CoverageProvider.this.getSettings().getMetricsScope().isScopeClassContainer(element);
                }
                catch (CoreException e) {
                    return false;
                }
            }

            private boolean inMetricsRange(Object element) {
                BlockMetrics fullMetrics = MetricsScope.FULL.getMetricsFor(element);
                BlockMetrics appropriateMetrics = CoverageProvider.this.getSettings().getMetricsScope().getMetricsFor(element);
                boolean accept = false;
                if (!(CoverageProvider.this.getSettings().shouldHideUnavailableCoverage() && CoverageProvider.this.isCoverageUnavailable(element, appropriateMetrics) || CoverageProvider.this.getSettings().shouldHideFullyCovered() && CoverageProvider.this.isFullyCovered(element, fullMetrics))) {
                    accept = true;
                }
                return accept;
            }

            @Override
            public boolean requiresFiltering() {
                return super.requiresFiltering() || CoverageProvider.this.getSettings().getCoverageModel() != 0 || CoverageProvider.this.getSettings().shouldHideUnavailableCoverage() || CoverageProvider.this.getSettings().shouldHideFullyCovered();
            }
        };
    }

    private boolean isFullyCovered(Object element, BlockMetrics metrics) {
        boolean result;
        boolean bl = result = metrics != null && metrics.getNumElements() > 0 && metrics.getNumCoveredElements() == metrics.getNumElements() && !TypeUtils.isProject(element);
        return result;
    }

    private boolean isCoverageUnavailable(Object element, BlockMetrics metrics) {
        try {
            if (TypeUtils.isPackageFragmentRoot(element)) {
                return false;
            }
            if (TypeUtils.isType(element)) {
                if (TypeUtils.unavailableCoverage(metrics)) {
                    IType[] innerTypes;
                    IType type = (IType)element;
                    for (IType innerType : innerTypes = type.getTypes()) {
                        if (this.isCoverageUnavailable(innerType, MetricsScope.FULL.getMetricsFor(innerType))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return TypeUtils.unavailableCoverage(metrics);
        }
        catch (JavaModelException e) {
            CloverPlugin.logError("Unable to determine inner classes", e);
            return false;
        }
    }

    private CoverageViewSettings getSettings() {
        return (CoverageViewSettings)this.settings;
    }
}

