/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.projects.CloverProject;
import org.openclover.eclipse.core.views.actions.SingleCloverProjectActionDelegate;

public class ToggleSingleCloverProjectNatureActionDelegate
extends SingleCloverProjectActionDelegate {
    public void run(IAction action) {
        boolean showCloverViews = false;
        for (IProject project : this.projects) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject == null || !project.exists() || !project.isOpen()) continue;
            showCloverViews |= !this.isCloverEnabled(project) & CloverProject.toggleWithUserFeedback(this.getShell(), javaProject);
        }
        try {
            if (CloverPlugin.getInstance().getInstallationSettings().isAutoOpenCloverViews() && showCloverViews) {
                CloverPlugin.getInstance().showViews(this.getPage());
            }
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to show views after toggling Clover", e);
        }
    }

    private boolean isCloverEnabled(IProject project) {
        try {
            return CloverProject.isAppliedTo(project);
        }
        catch (CoreException e) {
            return false;
        }
    }

    @Override
    protected boolean enableFor(IProject project) throws CoreException {
        return project.isAccessible();
    }
}

