/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ColumnCollectionSettings;
import org.openclover.eclipse.core.views.nodes.NodeHierarchyBuilder;

public abstract class ExplorerViewSettings
implements IPersistable {
    public static final String HIERARCHY_STYLE = "hierarchy.style";
    protected int hierarchyStyle = this.defaultHierarchyStyle();
    protected ColumnCollectionSettings treeColumnSettings;

    public ExplorerViewSettings(IMemento memento) {
        Integer hierarchyStyle;
        this.treeColumnSettings = new ColumnCollectionSettings(memento, this.allTreeColumns(), this.defaultTreeColumns(), this.defaultTreeColumnWidths());
        if (memento != null && (hierarchyStyle = memento.getInteger(HIERARCHY_STYLE)) != null) {
            this.hierarchyStyle = hierarchyStyle;
        }
    }

    protected abstract List allTreeColumns();

    protected abstract List defaultTreeColumns();

    protected abstract List defaultTreeColumnWidths();

    public ColumnCollectionSettings getTreeColumnSettings() {
        return this.treeColumnSettings;
    }

    public void saveState(IMemento memento) {
        memento.putInteger(HIERARCHY_STYLE, this.hierarchyStyle);
        this.treeColumnSettings.saveState(memento);
    }

    protected abstract int defaultHierarchyStyle();

    public void setHierarchyStyle(int style) {
        this.hierarchyStyle = style;
    }

    public int getHierarchyStyle() {
        return this.hierarchyStyle;
    }

    public abstract MetricsScope getMetricsScope();

    public NodeHierarchyBuilder nodeBuilderForStyle() {
        if (this.hierarchyStyle >= this.getHierarchyStyleStart() && this.hierarchyStyle <= this.getHierarchyStyleMax()) {
            return this.getNodeBuilders()[this.hierarchyStyle];
        }
        return this.getNodeBuilders()[this.defaultHierarchyStyle()];
    }

    protected abstract int expandDepthForStyle();

    protected abstract NodeHierarchyBuilder[] getNodeBuilders();

    protected abstract int getHierarchyStyleMax();

    protected abstract int getHierarchyStyleStart();
}

