/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import com.atlassian.clover.registry.metrics.BlockMetrics;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.ViewerComparator;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.CustomColumnDefinition;

public abstract class ExplorerViewComparator
extends ViewerComparator {
    protected static final Double NOT_AVAILABLE_DOUBLE = -1.0;

    public static int compareName(Object value1, Object value2) {
        return ExplorerViewComparator.nameOf(value1).compareToIgnoreCase(ExplorerViewComparator.nameOf(value2));
    }

    private static String nameOf(Object value) {
        String name1 = value instanceof IJavaElement ? ((IJavaElement)value).getElementName() : (value instanceof IProject ? ((IProject)value).getName() : (value instanceof IAdaptable ? ExplorerViewComparator.nameOf(((IAdaptable)value).getAdapter(IJavaElement.class)) : String.valueOf(value)));
        return name1;
    }

    protected int invert(boolean reverseIt, int comparisonResult) {
        return (reverseIt ? -1 : 1) * comparisonResult;
    }

    protected static int compareCustomColumn(MetricsScope scope, CustomColumnDefinition column, Object value1, Object value2) {
        Double custom2;
        Double custom1;
        BlockMetrics metrics1 = scope.getMetricsFor(value1);
        BlockMetrics metrics2 = scope.getMetricsFor(value2);
        try {
            custom1 = metrics1 == null ? NOT_AVAILABLE_DOUBLE : Double.valueOf(column.calculate(metrics1));
        }
        catch (Exception e) {
            custom1 = NOT_AVAILABLE_DOUBLE;
        }
        try {
            custom2 = metrics2 == null ? NOT_AVAILABLE_DOUBLE : Double.valueOf(column.calculate(metrics2));
        }
        catch (Exception e) {
            custom2 = NOT_AVAILABLE_DOUBLE;
        }
        return custom1.compareTo(custom2);
    }

    public static int compareType(Object object1, Object object2) {
        int value2;
        object1 = ExplorerViewComparator.sanitizeType(object1);
        object2 = ExplorerViewComparator.sanitizeType(object2);
        int value1 = ExplorerViewComparator.typeValueFor(object1);
        return value1 < (value2 = ExplorerViewComparator.typeValueFor(object2)) ? -1 : (value1 > value2 ? 1 : 1);
    }

    private static int typeValueFor(Object object) {
        if (object instanceof IProject) {
            return 0;
        }
        if (object instanceof IPackageFragmentRoot) {
            return 1;
        }
        if (object instanceof IPackageFragment) {
            return 2;
        }
        if (object instanceof ICompilationUnit) {
            return 3;
        }
        if (object instanceof IType) {
            return 4;
        }
        if (object instanceof IJavaElement) {
            return 5;
        }
        return Integer.MAX_VALUE;
    }

    private static Object sanitizeType(Object object) {
        return object instanceof IJavaElement ? (IJavaElement)object : (object instanceof IAdaptable ? (IJavaElement)((IAdaptable)object).getAdapter(IJavaElement.class) : object);
    }
}

