/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.Comparator;
import java.util.WeakHashMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.openclover.eclipse.core.projects.model.MetricsScope;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.widgets.ListeningRenderer;
import org.openclover.eclipse.core.views.widgets.SelectionAwareCellRenderer;

public abstract class ColumnDefinition {
    public static final int ANY_COLUMN = -1;
    public static final Comparator TITLE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((ColumnDefinition)o1).getTitle().compareTo(((ColumnDefinition)o2).getTitle());
        }
    };
    private final String id;
    private final int lockedColumnIndex;
    private int alignment;
    private String title;
    private String abbreviatedTitle;
    private String tooltip;
    private WeakHashMap renderers;

    protected ColumnDefinition(String id, int pinndedIndex, int alignment, String title, String abbreviatedTitle, String tooltip) {
        this.id = id;
        this.lockedColumnIndex = pinndedIndex;
        this.alignment = alignment == 16384 || alignment == 0x1000000 || alignment == 131072 ? alignment : 16384;
        this.title = title;
        this.abbreviatedTitle = abbreviatedTitle;
        this.tooltip = tooltip;
        this.renderers = new WeakHashMap();
    }

    public String getTitle() {
        return this.title;
    }

    public String getAbbreviatedTitle() {
        return this.abbreviatedTitle;
    }

    public String getId() {
        return this.id;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public boolean isLocked() {
        return this.lockedColumnIndex != -1;
    }

    public int getLockedColumnIndex() {
        return this.lockedColumnIndex;
    }

    public void bindRenderer(Composite composite, ExplorerViewSettings settings) {
        ListeningRenderer renderer = this.newRenderer(composite, settings);
        if (renderer != null) {
            renderer.startListening(composite);
            this.renderers.put(composite, renderer);
        }
    }

    public void unbindRenderer(Composite composite) {
        ListeningRenderer renderer = (ListeningRenderer)this.renderers.remove(composite);
        if (renderer != null) {
            renderer.stopListening(composite);
        }
    }

    public ListeningRenderer newRenderer(Composite composite, ExplorerViewSettings settings) {
        return new SelectionAwareCellRenderer(settings.getTreeColumnSettings(), this, composite){};
    }

    public abstract boolean isCustom();

    public abstract String getLabel(ExplorerViewSettings var1, MetricsScope var2, ILabelProvider var3, Object var4);

    public Image getImage(ExplorerViewSettings settings, MetricsScope scope, ILabelProvider delegate, Object element) {
        return null;
    }

    public abstract Comparator getComparator(ExplorerViewSettings var1, MetricsScope var2);

    public boolean displaysSimpleLabel() {
        return false;
    }

    public boolean displaysImage() {
        return false;
    }
}

