/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.views;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeEvent;
import org.openclover.eclipse.core.ui.projects.DatabaseChangeListener;
import org.openclover.eclipse.core.views.ExplorerView;
import org.openclover.eclipse.core.views.ExplorerViewSettings;
import org.openclover.eclipse.core.views.nodes.NodeHierarchyBuilder;
import org.openclover.eclipse.core.views.nodes.NodeRelationshipFilter;

public abstract class CloveredWorkspaceProvider
extends WorkbenchContentProvider
implements IElementChangedListener,
DatabaseChangeListener {
    private static final int IJAVAELEMENTDELTA_F_CLASSPATH_REORDER = 256;
    protected ExplorerView part;
    protected ExplorerViewSettings settings;
    protected NodeHierarchyBuilder nodeBuilder;

    public CloveredWorkspaceProvider(ExplorerView part, ExplorerViewSettings settings) {
        this.part = part;
        this.settings = settings;
        this.nodeBuilder = settings.nodeBuilderForStyle();
        CloverPlugin.getInstance().getCoverageMonitor().addCoverageChangeListener(this);
    }

    public void dispose() {
        super.dispose();
        CloverPlugin.getInstance().getCoverageMonitor().removeCoverageChangeListener(this);
    }

    public Object[] getChildren(Object object) {
        Object[] result = this.nodeBuilder.getChildren(object, this.getFilter());
        return result == null ? super.getChildren(object) : result;
    }

    public boolean hasChildren(Object object) {
        Boolean result = this.nodeBuilder.hasChildren(object, this.getFilter());
        return result == null ? super.hasChildren(object) : result.booleanValue();
    }

    public Object[] getElements(Object parent) {
        Object[] result = this.nodeBuilder.getElements(parent, this.getFilter());
        return result == null ? super.getElements(parent) : result;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (oldInput == null && newInput != null) {
            JavaCore.addElementChangedListener((IElementChangedListener)this);
        } else if (oldInput != null && newInput == null) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
        }
    }

    public void elementChanged(ElementChangedEvent event) {
        Object[] affectedElements;
        try {
            affectedElements = this.processDelta(event.getDelta()).toArray();
        }
        catch (BreakDeltaProcessing breakDeltaProcessing) {
            affectedElements = ExplorerView.ENTIRE_WORKSPACE;
        }
        if (affectedElements.length > 0) {
            this.part.refresh(true, affectedElements);
        }
    }

    private Set<IJavaProject> processDelta(IJavaElementDelta delta) throws BreakDeltaProcessing {
        return this.processDelta(new HashSet<IJavaProject>(), delta);
    }

    private Set<IJavaProject> processDelta(Set<IJavaProject> changes, IJavaElementDelta delta) throws BreakDeltaProcessing {
        switch (delta.getKind()) {
            case 1: 
            case 2: {
                if (delta.getElement().getElementType() == 2) {
                    throw new BreakDeltaProcessing();
                }
                changes.add(delta.getElement().getJavaProject());
                break;
            }
            case 4: {
                if ((delta.getFlags() & 8) != 0) {
                    IJavaElementDelta[] children;
                    for (IJavaElementDelta child : children = delta.getAffectedChildren()) {
                        this.processDelta(changes, child);
                    }
                    break;
                }
                if ((delta.getFlags() & 0x200) == 0 && (delta.getFlags() & 0x400) == 0) break;
                throw new BreakDeltaProcessing();
            }
        }
        return changes;
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent event) {
        if (event.isSubstantiveProjectChange()) {
            this.part.refresh(true, ExplorerView.ENTIRE_WORKSPACE);
        }
    }

    public void setNodeBuilder(NodeHierarchyBuilder nodeBuilder) {
        this.nodeBuilder = nodeBuilder;
    }

    protected abstract NodeRelationshipFilter getFilter();

    private class BreakDeltaProcessing
    extends Exception {
        private BreakDeltaProcessing() {
        }
    }
}

