/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.upgrade.hooks;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.upgrade.hooks.ConfigUpdateAbortedException;
import org.openclover.eclipse.core.upgrade.hooks.ConfigUpdateException;
import org.openclover.eclipse.core.upgrade.hooks.ConfigUpdateFailedException;
import org.openclover.util.Lists;

public class ConfigUninstaller {
    private static final String EXTENSION_REGEX = "^(\\s)*osgi\\.framework\\.extensions(\\s)*=(\\s)*(.*)$";
    private static final String OSGI_CONFIG_AREA_PROPERTY = "osgi.configuration.area";
    private static final String CONFIG_INI = "config.ini";
    private static final String EXTENSION_LINE_START = "osgi.framework.extensions=";
    private static final String CSV_TRIMMED_SEP = "(\\s)*,(\\s)*";
    private static final String HOOK_ID = "com.atlassian.clover.hooks";
    private static final String MESSAGEBOX_UNINSTALL_TITLE = "Clover JDT Hooks Uninstallation";
    private static final String ALREADY_UNINSTALLED_HOOK_THIS_SESSION_PROPERTY = "clover.eclipse.hook.already.uninstalled.this.session";
    private static final String MESSAGEBOX_TITLE = "Clover JDT Hooks Uninstaller";
    private static final String PERMISSION_TEXT = "Clover must update the config.ini configuration file of your Eclipse installation.\n\nClick Proceed to allow Clover to perform this action or click Skip if you wish to\nperform this yourself. Instructions on how to do this are provided within the \nonline Clover Eclipse documentation.";

    private void patchConfigIni(File configIni, File configIniBackup) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(configIni));
        ArrayList<String> lines = new ArrayList<String>(50);
        ArrayList<String> oldLines = new ArrayList<String>(50);
        Pattern extensionsPattern = Pattern.compile(EXTENSION_REGEX);
        while ((line = reader.readLine()) != null) {
            oldLines.add(line);
            Matcher matcher = extensionsPattern.matcher(line);
            if (matcher.matches()) {
                line = this.removeExtensionFromLine(matcher);
            }
            if (line == null) continue;
            lines.add(line);
        }
        this.swapConfigFile(configIni, configIniBackup, oldLines, lines);
        System.setProperty(ALREADY_UNINSTALLED_HOOK_THIS_SESSION_PROPERTY, Boolean.TRUE.toString());
    }

    private String removeExtensionFromLine(Matcher matcher) {
        String line = null;
        String extensionsString = matcher.group(4);
        ArrayList<String> extensions = Lists.newArrayList(extensionsString.split(CSV_TRIMMED_SEP));
        extensions.remove(HOOK_ID);
        if (extensions.size() > 0) {
            line = EXTENSION_LINE_START;
            for (int i = 0; i < extensions.size(); ++i) {
                String extension = (String)extensions.get(i);
                line = line + extension;
                if (i >= extensions.size() - 1) continue;
                line = line + ",";
            }
        }
        return line;
    }

    private File getBackupConfigIni(File configArea) {
        return new File(configArea, "config.ini.uninstall.clover.bak");
    }

    public boolean run() {
        if (this.permissionGrantedByUser()) {
            try {
                URL configAreaUrl;
                try {
                    configAreaUrl = new URL(System.getProperty(OSGI_CONFIG_AREA_PROPERTY));
                }
                catch (MalformedURLException e) {
                    throw new ConfigUpdateAbortedException("Clover was unable to locate your Eclipse configuration directory.\nNo configuration updates were performed. Please contact support - https://openclover.org/support", e);
                }
                File configArea = new File(configAreaUrl.getFile());
                if (!(configArea != null && configArea.exists() && configArea.isDirectory() && configArea.canWrite())) {
                    throw new ConfigUpdateAbortedException("Clover is unable to write to your Eclipse configuration directory.\nNo configuration updates were performed. Please contact support - https://openclover.org/support");
                }
                File configIni = new File(configArea, CONFIG_INI);
                File configIniBackup = this.getBackupConfigIni(configArea);
                if (!(configIni.exists() && configIni.isFile() && configIni.canWrite())) {
                    throw new ConfigUpdateAbortedException("Clover is unable to write to your Eclipse configuration file \"config.ini\".\nNo configuration updates were performed. Please contact support - https://openclover.org/support");
                }
                try {
                    this.patchConfigIni(configIni, configIniBackup);
                }
                catch (Exception e) {
                    throw new ConfigUpdateFailedException("Clover encountered an error while updating Eclipse's conifg.ini.\nPlease contact support - https://openclover.org/support", e);
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)ConfigUninstaller.MESSAGEBOX_TITLE, (String)"Clover successfully updated your config.ini file.\nPlease restart Eclipse for this change to take effect.");
                    }
                });
                return true;
            }
            catch (ConfigUpdateException e) {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)ConfigUninstaller.MESSAGEBOX_TITLE, (String)e.getMessage());
                    }
                });
            }
        }
        return false;
    }

    public boolean permissionGrantedByUser() {
        final boolean[] permissionGranted = new boolean[]{false};
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(Display.getDefault().getActiveShell(), ConfigUninstaller.MESSAGEBOX_TITLE, null, ConfigUninstaller.PERMISSION_TEXT, 3, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                int dialogResult = dialog.open();
                permissionGranted[0] = dialogResult == 0;
            }
        });
        return permissionGranted[0];
    }

    private void swapConfigFile(File configIni, File configIniBackup, List oldLines, List newLines) throws IOException {
        File tempFile = File.createTempFile("config", "ini");
        this.writeFile(newLines, tempFile);
        if (configIniBackup.exists()) {
            configIniBackup.delete();
            configIniBackup.createNewFile();
        }
        this.writeFile(oldLines, configIniBackup);
        this.writeFile(newLines, configIni);
    }

    private void writeFile(List<String> newLines, File tempFile) throws IOException {
        FileWriter iniFileWriter = new FileWriter(tempFile);
        BufferedWriter iniWriter = new BufferedWriter(iniFileWriter);
        for (String s : newLines) {
            iniWriter.write(s);
            iniWriter.newLine();
        }
        iniWriter.flush();
        iniWriter.close();
    }

    public boolean isHookInstalled() {
        block6: {
            URL configAreaUrl = null;
            try {
                configAreaUrl = new URL(System.getProperty(OSGI_CONFIG_AREA_PROPERTY));
                File configArea = new File(configAreaUrl.getFile());
                if (!(configArea.exists() && configArea.isDirectory() && configArea.canWrite())) {
                    CloverPlugin.logVerbose("Clover is unable to write to your Eclipse confiuration directory.\nNo configuration updates were performed.");
                    break block6;
                }
                File configIni = new File(configArea, CONFIG_INI);
                if (!(configIni.exists() && configIni.isFile() && configIni.canWrite())) {
                    CloverPlugin.logVerbose("Clover is unable to write to your Eclipse configuration file \"config.ini\".\nNo configuration updates were performed.");
                    break block6;
                }
                try {
                    return ConfigUninstaller.isHookInstalled(configIni);
                }
                catch (Exception e) {
                    CloverPlugin.logError("Clover encountered an error while reading Eclipse's conifg.ini.\n" + e);
                }
            }
            catch (MalformedURLException e) {
                CloverPlugin.logVerbose("Clover was unable to locate your Eclipse confiuration directory.\nNo configuration updates were performed.", e);
            }
        }
        return false;
    }

    private static boolean isHookInstalled(File configIni) throws IOException {
        if (!Boolean.parseBoolean(System.getProperty(ALREADY_UNINSTALLED_HOOK_THIS_SESSION_PROPERTY))) {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(configIni));
            Pattern extensionsPattern = Pattern.compile(EXTENSION_REGEX);
            while ((line = reader.readLine()) != null) {
                Matcher matcher = extensionsPattern.matcher(line);
                if (!matcher.matches()) continue;
                return matcher.group(4) != null && matcher.group(4).contains(HOOK_ID);
            }
        }
        return false;
    }
}

