/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.BrowserUtils;

public class DialogWithHyperlink
extends IconAndMessageDialog {
    private final String linkText;
    private final String title;

    public DialogWithHyperlink(Shell parentShell, String title, String message) {
        super(parentShell);
        this.title = title;
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.message = null;
        this.linkText = message;
    }

    protected Control createDialogArea(Composite parent) {
        this.createMessageArea(parent);
        this.getShell().setText(this.title);
        if (this.linkText != null) {
            Link link = new Link(parent, this.getMessageLabelStyle());
            link.setText(this.linkText);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowserUtils.openExternalBrowser(e.text);
                }
            });
            int lineHeight = this.convertHeightInCharsToPixels(1);
            int minimumWidth = this.convertHorizontalDLUsToPixels(300);
            int computedMinimumHeight = link.computeSize((int)-1, (int)-1, (boolean)true).y + 1 * lineHeight;
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).minSize(1, computedMinimumHeight).hint(minimumWidth, -1).applyTo((Control)link);
        }
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Image getImage() {
        return CloverPlugin.getImage("icons/logo.png");
    }
}

