/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.widgets;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.context.NamedContext;
import java.util.HashMap;
import java.util.List;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.ui.widgets.BuiltinContextFilterSelectionWidget;
import org.openclover.util.Maps;

public class ContextFilterSelectionWidget
extends BuiltinContextFilterSelectionWidget {
    protected HashMap<String, Button> customCheckboxes = Maps.newHashMap();

    public ContextFilterSelectionWidget(Composite parent, ContextStore contextStore, ContextSet filter) {
        super(parent, contextStore, filter);
    }

    @Override
    public void buildContents() {
        super.buildContents();
        if (this.contextStore.getAllUserContexts().size() > 0) {
            Label blockLabel = new Label((Composite)this, 16384);
            blockLabel.setText(CloverEclipsePluginMessages.REGEXP_CONTEXT_FILTER_SELECTION_INSTRUCTIONS());
            Composite container = new Composite((Composite)this, 0);
            container.setLayout((Layout)new GridLayout(3, true));
            List<NamedContext> customContexts = this.contextStore.getAllUserContexts();
            for (NamedContext context : customContexts) {
                Button check = new Button(container, 32);
                check.setText(context.getName());
                check.setSelection(false);
                this.customCheckboxes.put(context.getName(), check);
            }
        }
    }

    @Override
    public void updateSelection() {
        NamedContext[] namedContexts;
        super.updateSelection();
        for (NamedContext namedContext : namedContexts = this.contextStore.getContexts(this.filter)) {
            Button checkbox = this.customCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            checkbox.setSelection(true);
        }
    }

    @Override
    public ContextSet getFilterFromSelection(ContextSet filter) {
        super.getFilterFromSelection(filter);
        List<NamedContext> customContext = this.contextStore.getAllUserContexts();
        for (NamedContext namedContext : customContext) {
            Button checkbox = this.customCheckboxes.get(namedContext.getName());
            if (checkbox == null) continue;
            filter = filter.set(namedContext.getIndex(), checkbox.getSelection());
        }
        return filter;
    }
}

