/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.treemap;

import net.sf.jtreemap.ktreemap.ITreeMapProvider;
import net.sf.jtreemap.ktreemap.KTreeMap;
import net.sf.jtreemap.ktreemap.SplitSquarified;
import net.sf.jtreemap.ktreemap.TreeMapNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.EditorPart;
import org.openclover.eclipse.core.CloverEclipsePluginMessages;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.GLH;
import org.openclover.eclipse.core.ui.editors.CloverProjectInput;
import org.openclover.eclipse.core.ui.editors.treemap.CloverTreeMap;
import org.openclover.eclipse.core.ui.editors.treemap.CloverTreeMapProvider;
import org.openclover.eclipse.core.ui.editors.treemap.EclipseCoverageColorProvider;
import org.openclover.eclipse.core.ui.editors.treemap.ProjectHeatMapBuilder;
import org.openclover.eclipse.core.ui.editors.treemap.TreemapInput;

public class TreemapEditor
extends EditorPart {
    public static final String ID = "org.openclover.eclipse.core.editors.treemap";
    private DrillDownAdapter drillDownAdapter;
    private Action openXmlAction;
    private Action openTM3Action;
    private Action selectionChangedAction;
    private KTreeMap treeMap;
    private Composite legend;
    private CloverTreeMapProvider cloverProvider;
    private Button refreshButton;

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof TreemapInput)) {
            throw new PartInitException("Invalid Input: must be TreemapInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(editorInput);
    }

    public boolean isDirty() {
        return false;
    }

    public void createPartControl(Composite composite) {
        this.cloverProvider = new CloverTreeMapProvider();
        TreeMapNode root = this.getRoot((CloverProjectInput)this.getEditorInput());
        composite.setLayout((Layout)new GLH().numColumns(1).getGridLayout());
        this.createKTreeMapComp(composite, root);
        this.createRefreshButton(composite);
        this.hookContextMenu();
    }

    private void createRefreshButton(Composite parent) {
        Composite row = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        row.setLayoutData((Object)gridData);
        row.setLayout((Layout)new GridLayout());
        this.refreshButton = new Button(row, 0);
        this.refreshButton.setImage(CloverPlugin.getImage("icons/clcl16/project_refresh.gif"));
        this.refreshButton.setText(CloverEclipsePluginMessages.REFRESH_CLOUD_BUTTON());
        this.refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TreemapEditor.this.treeMap.setRoot(TreemapEditor.this.getRoot((CloverProjectInput)TreemapEditor.this.getEditorInput()));
                        TreemapEditor.this.treeMap.redraw();
                    }
                });
            }
        });
    }

    private TreeMapNode getRoot(CloverProjectInput input) {
        return new ProjectHeatMapBuilder().buildTree(input.getProject());
    }

    public void doSave(IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Save not permitted");
    }

    public void doSaveAs() {
        throw new UnsupportedOperationException("Save not permitted");
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setFocus() {
    }

    private void createKTreeMapComp(Composite parent, TreeMapNode root) {
        this.treeMap = new CloverTreeMap(this.getJavaProject(), this.getSite(), parent, 0, root);
        this.treeMap.setTreeMapProvider(this.cloverProvider);
        this.treeMap.setColorProvider(new EclipseCoverageColorProvider(this.cloverProvider));
        this.treeMap.setStrategy(new SplitSquarified());
        GridData gridData = new GridData(1808);
        this.treeMap.setLayoutData(gridData);
    }

    private IJavaProject getJavaProject() {
        try {
            return ((CloverProjectInput)this.getEditorInput()).getProject().getJavaProject();
        }
        catch (CoreException e) {
            CloverPlugin.logError("Unable to retrieve Java project for treemap editor", e);
            return null;
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        ZoomAction action;
        TreeMapNode orig = this.treeMap.getDisplayedRoot();
        ITreeMapProvider provider = this.treeMap.getTreeMapProvider();
        TreeMapNode cursor = orig;
        String id = "separator";
        manager.add((IContributionItem)new Separator(id));
        while (cursor.getParent() != null) {
            TreeMapNode parent = cursor.getParent();
            action = new ZoomAction(provider.getLabel(parent), CloverPlugin.getImageDescriptor("icons/clcl16/zoomout.gif"), parent);
            manager.insertBefore(id, (IAction)action);
            cursor = parent;
            id = action.getId();
        }
        cursor = orig;
        while (cursor.getChild(this.treeMap.getCursorPosition()) != null) {
            TreeMapNode child = cursor.getChild(this.treeMap.getCursorPosition());
            if (!child.isLeaf()) {
                action = new ZoomAction(provider.getLabel(child), CloverPlugin.getImageDescriptor("icons/clcl16/zoomin.gif"), child);
                manager.add((IAction)action);
            }
            cursor = child;
        }
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.drillDownAdapter.addNavigationActions(manager);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                TreemapEditor.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.treeMap);
        this.treeMap.setMenu(menu);
    }

    private class ZoomAction
    extends Action {
        private TreeMapNode node;

        public ZoomAction(String text, ImageDescriptor image, TreeMapNode node) {
            super(text, image);
            this.node = node;
            this.setId(text);
        }

        public boolean isEnabled() {
            return true;
        }

        public void run() {
            TreemapEditor.this.treeMap.zoom(this.node);
            TreemapEditor.this.treeMap.redraw();
        }
    }
}

