/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.treemap;

import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.metrics.BlockMetrics;
import java.text.DecimalFormat;
import net.sf.jtreemap.ktreemap.ITreeMapProvider;
import net.sf.jtreemap.ktreemap.TreeMapNode;

public class CloverTreeMapProvider
implements ITreeMapProvider {
    private final DecimalFormat PERCENTAGE_FORMAT = new DecimalFormat("###.##%");

    @Override
    public String getLabel(TreeMapNode node) {
        if (node.getValue() instanceof HasMetrics) {
            return ((HasMetrics)node.getValue()).getName();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValueLabel(Object value) {
        DecimalFormat decimalFormat = this.PERCENTAGE_FORMAT;
        synchronized (decimalFormat) {
            return this.PERCENTAGE_FORMAT.format(this.getDoubleValue(value));
        }
    }

    @Override
    public double getDoubleValue(Object value) {
        if (value instanceof HasMetrics) {
            float pcCoveredElements = ((HasMetrics)value).getMetrics().getPcCoveredElements();
            return pcCoveredElements == BlockMetrics.VALUE_UNDEFINED ? (double)BlockMetrics.VALUE_UNDEFINED : (double)pcCoveredElements;
        }
        return 0.0;
    }
}

