/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.BranchInfo;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.api.registry.StatementInfo;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.CoverageAnnotationBuilder;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationFragment;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationSpace;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationSpaceWithFragments;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.DocumentUtils;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.RootAnnotationSpace;

public class CoverageAnnotationSpaceBuilder
implements CoverageAnnotationBuilder {
    private static final boolean DEBUG_ENABLED = CloverPlugin.isLoggingDebugFor("annotations");
    private CloverDatabase database;
    private IDocument document;
    private AnnotationSpace root;
    private AnnotationSpace currentSpace;

    public CoverageAnnotationSpaceBuilder(CloverDatabase database, IDocument document, Map<TestCaseInfo, BitSet> tcisAndHitsForFile) throws BadLocationException {
        this.database = database;
        this.document = document;
        this.currentSpace = this.root = new RootAnnotationSpace(database, document, tcisAndHitsForFile);
    }

    @Override
    public void onStartOfSourceRegion(SourceInfo region, boolean hidden) throws BadLocationException {
        if (DEBUG_ENABLED) {
            System.out.println("ELEMENT START : " + this.toString(region));
        }
        if (this.currentSpace instanceof AnnotationSpaceWithFragments && ((AnnotationSpaceWithFragments)this.currentSpace).currentFragmentCompatibleWith(region, hidden)) {
            ((AnnotationSpaceWithFragments)this.currentSpace).foldIntoCurrentFragment(region, hidden);
        } else {
            if (DEBUG_ENABLED) {
                System.out.println("Beginning space: " + this.kind(region) + " [" + region.getStartLine() + "," + region.getStartColumn() + "] -> [" + region.getEndLine() + "," + region.getEndColumn() + "]" + (hidden ? " (hidden" : ""));
                System.out.println(">>>>\n" + this.document.get(DocumentUtils.lineColToOffset(this.document, region.getStartLine(), region.getStartColumn()), DocumentUtils.lineColToOffset(this.document, region.getEndLine(), region.getEndColumn()) - DocumentUtils.lineColToOffset(this.document, region.getStartLine(), region.getStartColumn())) + "\n<<<<\n");
            }
            this.currentSpace = this.currentSpace.newChildSpace(region, hidden);
        }
    }

    @Override
    public void onEndOfSourceRegion(SourceInfo region, boolean hidden) throws BadLocationException {
        if (DEBUG_ENABLED) {
            System.out.println("ELEMENT END : " + this.toString(region));
        }
        if (((AnnotationSpaceWithFragments)this.currentSpace).isOriginalFragmentStartedBy(region)) {
            if (DEBUG_ENABLED) {
                SourceInfo startRegion = ((AnnotationSpaceWithFragments)this.currentSpace).getFirstFragment().getRegion();
                System.out.println("Ending space: " + this.kind(startRegion) + " [" + startRegion.getStartLine() + "," + startRegion.getStartColumn() + "] -> [" + region.getEndLine() + "," + region.getEndColumn() + "]" + (hidden ? " (hidden" : ""));
                String fragment = this.document.get(DocumentUtils.lineColToOffset(this.document, startRegion.getStartLine(), startRegion.getStartColumn()), DocumentUtils.lineColToOffset(this.document, region.getEndLine(), region.getEndColumn()) - DocumentUtils.lineColToOffset(this.document, startRegion.getStartLine(), startRegion.getStartColumn()));
                if (fragment.startsWith("for (;;)")) {
                    System.out.println("PARENT: " + this.currentSpace.getParent().toString());
                }
                System.out.println(">>>>\n" + fragment + "\n<<<<\n");
            }
            this.currentSpace = this.currentSpace.seal(region, hidden);
        } else if (DEBUG_ENABLED && this.currentSpace instanceof AnnotationSpaceWithFragments) {
            boolean outOfPlace = true;
            for (AnnotationFragment current : ((AnnotationSpaceWithFragments)this.currentSpace).getFragments()) {
                if (current.getRegion() != region) continue;
                outOfPlace = false;
                break;
            }
            if (outOfPlace) {
                throw new AssertionError((Object)("Region out of place: " + this.kind(region) + " [" + region.getStartLine() + "," + region.getStartColumn() + "] -> [" + region.getEndLine() + "," + region.getEndColumn() + "]" + (hidden ? " (hidden" : "") + "Current space: " + this.currentSpace.toString()));
            }
        }
    }

    private String toString(SourceInfo region) throws BadLocationException {
        int startOffset = DocumentUtils.lineColToOffset(this.document, region.getStartLine(), region.getStartColumn());
        int endOffset = DocumentUtils.lineColToOffset(this.document, region.getEndLine(), region.getEndColumn());
        return this.kind(region) + " [" + region.getStartLine() + "," + region.getStartColumn() + "] -> [" + region.getEndLine() + "," + region.getEndColumn() + "]: " + this.charsWithElipses(this.document, 60, startOffset, endOffset);
    }

    private String kind(SourceInfo region) {
        if (region instanceof BaseClassInfo) {
            return "CLASS";
        }
        if (region instanceof MethodInfo) {
            return "METHOD";
        }
        if (region instanceof StatementInfo) {
            return "STATEMENT";
        }
        if (region instanceof BranchInfo) {
            return "BRANCH";
        }
        return region.getClass().getName();
    }

    private String charsWithElipses(IDocument document, int length, int startOffset, int endOffset) throws BadLocationException {
        String flattenedString = document.get(startOffset, endOffset - startOffset).replaceAll("\n", "\\\\n");
        if (flattenedString.length() <= length) {
            return "\"" + flattenedString + "\"";
        }
        int charsToShow = length - 3;
        int frontCharsToShow = charsToShow / 2;
        int backCharsToShow = charsToShow - frontCharsToShow;
        return "\"" + flattenedString.substring(0, frontCharsToShow) + "..." + flattenedString.substring(flattenedString.length() - backCharsToShow, flattenedString.length()) + "\"";
    }

    @Override
    public SortedSet<CoverageAnnotation> toAnnotations(SortedSet<CoverageAnnotation> annotations) throws BadLocationException {
        return this.root.toAnnotations(annotations);
    }
}

