/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationFragment;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationFragmentOnResumption;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationFragmentOnStart;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.AnnotationSpace;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.DocumentUtils;
import org.openclover.util.Lists;

class AnnotationSpaceWithFragments
extends AnnotationSpace {
    private AnnotationSpace parent;
    protected List<AnnotationFragment> fragments = Lists.newLinkedList();

    public AnnotationSpaceWithFragments(CloverDatabase database, IDocument document, Map<TestCaseInfo, BitSet> tcisAndHitsForFile, AnnotationSpace parent, SourceInfo region, boolean hidden) throws BadLocationException {
        super(database, document, tcisAndHitsForFile);
        this.parent = parent;
        this.foldIntoCurrentFragment(region, hidden);
    }

    @Override
    protected AnnotationSpace getParent() {
        return this.parent;
    }

    public boolean isOriginalFragmentStartedBy(SourceInfo region) {
        return this.getFirstFragment().getRegion() == region;
    }

    public void resumeWithNewAnnotationFragment(SourceInfo region) throws BadLocationException {
        this.fragments.add(new AnnotationFragmentOnResumption(this.database, this.document, this.getFirstFragment().getRegion(), this.tcisAndHitsForFile, this.getFirstFragment().isHidden(), DocumentUtils.lineColToOffset(this.document, region.getEndLine(), region.getEndColumn())));
    }

    @Override
    public AnnotationSpace newChildSpace(SourceInfo region, boolean hidden) throws BadLocationException {
        AnnotationSpace newSpace = super.newChildSpace(region, hidden);
        this.getLastFragment().closeBefore(region);
        return newSpace;
    }

    @Override
    public AnnotationSpace seal(SourceInfo region, boolean hidden) throws BadLocationException {
        super.seal(region, hidden);
        this.getLastFragment().closeAfter(region);
        if (this.parent instanceof AnnotationSpaceWithFragments) {
            ((AnnotationSpaceWithFragments)this.parent).resumeWithNewAnnotationFragment(region);
        }
        return this.parent;
    }

    @Override
    public SortedSet<CoverageAnnotation> toAnnotations(SortedSet<CoverageAnnotation> set) {
        super.toAnnotations(set);
        for (AnnotationFragment fragment : this.fragments) {
            set.add(fragment.toAnnotation());
        }
        return set;
    }

    public List<AnnotationFragment> getFragments() {
        return this.fragments;
    }

    private AnnotationFragment getLastFragment() {
        return this.fragments.size() == 0 ? null : this.fragments.get(this.fragments.size() - 1);
    }

    public boolean currentFragmentCompatibleWith(SourceInfo region, boolean hidden) {
        return this.fragments.get(0).compatibleWith(region, hidden);
    }

    public void foldIntoCurrentFragment(SourceInfo region, boolean hidden) throws BadLocationException {
        this.ensureNotSealed();
        if (this.getLastFragment() == null || this.getLastFragment().isClosed()) {
            this.fragments.add(new AnnotationFragmentOnStart(this.database, this.document, region, this.tcisAndHitsForFile, hidden));
        }
    }

    public AnnotationFragment getFirstFragment() {
        return this.fragments.get(0);
    }

    public String toString() {
        try {
            return "AnnotationSpaceWithFragments([" + this.getFirstFragment().getRegion().getStartLine() + "," + this.getFirstFragment().getRegion().getStartColumn() + "] -> [" + this.getLastFragment().getRegion().getEndLine() + "," + this.getLastFragment().getRegion().getEndColumn() + "],\n" + (this.getFirstFragment().isHidden() ? " hidden" : "visible") + "\n>>>>\n" + this.document.get(DocumentUtils.lineColToOffset(this.document, this.getFirstFragment().getRegion().getStartLine(), this.getFirstFragment().getRegion().getStartColumn()), DocumentUtils.lineColToOffset(this.document, this.getLastFragment().getRegion().getEndLine(), this.getLastFragment().getRegion().getEndColumn()) - DocumentUtils.lineColToOffset(this.document, this.getFirstFragment().getRegion().getStartLine(), this.getFirstFragment().getRegion().getStartColumn())) + "\n<<<<)\n";
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }
}

