/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.CoverageData;
import com.atlassian.clover.api.registry.ElementInfo;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.registry.CoverageDataRange;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.BitSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotation;
import org.openclover.eclipse.core.ui.editors.java.annotations.strategies.space.DocumentUtils;

abstract class AnnotationFragment {
    private final CloverDatabase database;
    private final IDocument document;
    private final SourceInfo region;
    private final Map<TestCaseInfo, BitSet> tcisAndHitsForFile;
    private final Set<TestCaseInfo> hits;
    private final boolean hidden;
    private final int startPos;
    private int length = -1;

    public AnnotationFragment(CloverDatabase database, IDocument document, SourceInfo region, Map<TestCaseInfo, BitSet> tcisAndHitsForFile, boolean hidden, int startPos) {
        this.database = database;
        this.document = document;
        this.region = region;
        this.tcisAndHitsForFile = tcisAndHitsForFile;
        this.hits = this.getTestHits(region);
        this.hidden = hidden;
        this.startPos = startPos;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public SourceInfo getRegion() {
        return this.region;
    }

    public void closeBefore(SourceInfo region) throws BadLocationException {
        this.length = DocumentUtils.lineColToOffset(this.document, region.getStartLine(), region.getStartColumn()) - this.startPos;
    }

    public void closeAfter(SourceInfo region) throws BadLocationException {
        this.length = DocumentUtils.lineColToOffset(this.document, region.getEndLine(), region.getEndColumn()) - this.startPos;
    }

    public CoverageAnnotation toAnnotation() {
        this.assertClosed();
        if (this.region instanceof FullElementInfo) {
            return CoverageAnnotation.Kind.kindFor(this.hidden, (ElementInfo)this.region, this.hits).newAnnotation((FullElementInfo)this.region, this.hits, this.startPos, this.length, this.hidden);
        }
        return null;
    }

    public boolean compatibleWith(SourceInfo region, boolean hidden) {
        Set<TestCaseInfo> thatRegionHits = this.getTestHits(region);
        return this.hidden == hidden && this.region.getClass() == region.getClass() && this.getHitCount(this.region) == this.getHitCount(region) && this.hits.containsAll(thatRegionHits) && thatRegionHits.containsAll(this.hits);
    }

    private int getHitCount(SourceInfo region) {
        return region instanceof ElementInfo ? ((ElementInfo)region).getHitCount() : 0;
    }

    private Set<TestCaseInfo> getTestHits(SourceInfo region) {
        if (region instanceof CoverageDataRange) {
            return CoverageData.tcisInHitRange(this.tcisAndHitsForFile, (CoverageDataRange)((Object)region));
        }
        return Collections.emptySet();
    }

    public Position getPosition() {
        this.assertClosed();
        return new Position(this.startPos, this.length);
    }

    private void assertClosed() {
        if (!this.isClosed()) {
            throw new AssertionError((Object)"Annotation fragment is not closed");
        }
    }

    public boolean isClosed() {
        return this.length >= 0;
    }

    public String toString() {
        try {
            if (this.isClosed()) {
                int startLine = this.document.getLineOfOffset(this.startPos);
                int endLine = this.document.getLineOfOffset(this.startPos + this.length);
                return "[" + startLine + "," + (this.startPos - this.document.getLineOffset(startLine)) + "]->[" + endLine + "," + (this.startPos + this.length - this.document.getLineOffset(endLine)) + "]";
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return "[?,?]->[?,?]";
    }
}

