/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import com.atlassian.clover.CloverDatabase;
import com.atlassian.clover.registry.entities.FullBranchInfo;
import com.atlassian.clover.registry.entities.FullElementInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullMethodInfo;
import com.atlassian.clover.registry.entities.FullStatementInfo;
import com.atlassian.clover.registry.entities.LineInfo;
import com.atlassian.clover.registry.entities.TestCaseInfo;
import java.util.Arrays;
import java.util.Set;
import org.openclover.eclipse.core.ui.editors.java.ILineCoverageModel;

public class LineCoverageModelImpl
implements ILineCoverageModel {
    private ILineCoverageModel.Entry[] entries;
    private boolean[] hasMisses;
    private boolean[] hasHits;
    private boolean[] hasPassedHits;
    private boolean[] hasFailedHits;
    private boolean[] isFiltered;

    public LineCoverageModelImpl(CloverDatabase cloverDatabase, FullFileInfo fileInfo) {
        LineInfo[] lineInfos = fileInfo.getLineInfo(true, true);
        TestStatus isPassedFailed = new TestStatus();
        this.entries = new ILineCoverageModel.Entry[lineInfos.length];
        this.hasMisses = new boolean[lineInfos.length];
        this.hasHits = new boolean[lineInfos.length];
        this.hasPassedHits = new boolean[lineInfos.length];
        this.hasFailedHits = new boolean[lineInfos.length];
        this.isFiltered = new boolean[lineInfos.length];
        Arrays.fill(this.isFiltered, true);
        for (LineInfo lineInfo : lineInfos) {
            FullBranchInfo[] fullBranchInfoArray;
            int n;
            if (lineInfo == null) continue;
            FullMethodInfo[] methodStarts = lineInfo.getMethodStarts();
            if (methodStarts != null && methodStarts.length > 0) {
                FullMethodInfo methodInfo = methodStarts[0];
                Set<TestCaseInfo> testCaseInfos = cloverDatabase.getTestHits(methodInfo);
                EntryImpl entryImpl = new EntryImpl(methodInfo, testCaseInfos);
                this.searchForPassedAndFailed(testCaseInfos, isPassedFailed);
                boolean isMethodFiltered = methodInfo.isFiltered(fileInfo.getContextFilter());
                int methodHitCount = methodInfo.getHitCount();
                for (int line = methodInfo.getStartLine(); line <= methodInfo.getEndLine(); ++line) {
                    this.entries[line] = entryImpl;
                    if (methodHitCount == 0) {
                        this.hasMisses[line] = true;
                    } else {
                        this.hasHits[line] = true;
                    }
                    if (isPassedFailed.passed) {
                        this.hasPassedHits[line] = true;
                    }
                    if (isPassedFailed.failed) {
                        this.hasFailedHits[line] = true;
                    }
                    if (isMethodFiltered) continue;
                    this.isFiltered[line] = false;
                }
                continue;
            }
            FullStatementInfo[] statements = lineInfo.getStatements();
            boolean isLineWithStatementsFiltered = true;
            if (statements != null && statements.length > 0) {
                FullStatementInfo[] fullStatementInfoArray = statements;
                int n2 = fullStatementInfoArray.length;
                for (n = 0; n < n2; ++n) {
                    FullStatementInfo statementInfo = fullStatementInfoArray[n];
                    if (statementInfo.isFiltered(fileInfo.getContextFilter())) continue;
                    isLineWithStatementsFiltered = false;
                    break;
                }
            }
            if (statements != null && statements.length > 0) {
                FullStatementInfo[] fullStatementInfoArray = statements;
                int n3 = fullStatementInfoArray.length;
                for (n = 0; n < n3; ++n) {
                    FullStatementInfo statementInfo = fullStatementInfoArray[n];
                    Set<TestCaseInfo> testCaseInfos = cloverDatabase.getTestHits(statementInfo);
                    EntryImpl entry = new EntryImpl(statementInfo, testCaseInfos);
                    this.searchForPassedAndFailed(testCaseInfos, isPassedFailed);
                    for (int line = statementInfo.getStartLine(); line <= statementInfo.getEndLine(); ++line) {
                        this.entries[line] = entry;
                        if (statementInfo.getHitCount() == 0) {
                            this.hasMisses[line] = true;
                        } else {
                            this.hasHits[line] = true;
                        }
                        if (isPassedFailed.passed) {
                            this.hasPassedHits[line] = true;
                        }
                        if (isPassedFailed.failed) {
                            this.hasFailedHits[line] = true;
                        }
                        if (this.isFiltered[line]) continue;
                        this.isFiltered[line] = isLineWithStatementsFiltered;
                    }
                }
            }
            if ((fullBranchInfoArray = lineInfo.getBranches()) == null || fullBranchInfoArray.length <= 0) continue;
            FullBranchInfo[] fullBranchInfoArray2 = fullBranchInfoArray;
            n = fullBranchInfoArray2.length;
            for (int i = 0; i < n; ++i) {
                FullBranchInfo branchInfo = fullBranchInfoArray2[i];
                for (int line = branchInfo.getStartLine(); line <= branchInfo.getEndLine(); ++line) {
                    if (branchInfo.getTrueHitCount() != 0 && branchInfo.getFalseHitCount() != 0) continue;
                    this.hasMisses[line] = true;
                }
            }
        }
    }

    @Override
    public boolean hasMissesInLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.hasMisses.length ? this.hasMisses[idx] : false;
    }

    @Override
    public boolean hasHitsInLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.hasHits.length ? this.hasHits[idx] : false;
    }

    @Override
    public boolean hasPassedHitsInLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.hasPassedHits.length ? this.hasPassedHits[idx] : false;
    }

    @Override
    public boolean hasFailedHitsInLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.hasFailedHits.length ? this.hasFailedHits[idx] : false;
    }

    @Override
    public boolean isFilteredInLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.isFiltered.length ? this.isFiltered[idx] : false;
    }

    @Override
    public ILineCoverageModel.Entry getForLine(int lineNumber) {
        int idx = lineNumber + 1;
        return idx < this.entries.length ? this.entries[idx] : null;
    }

    private void searchForPassedAndFailed(Set<TestCaseInfo> testCaseInfos, TestStatus out) {
        out.passed = false;
        out.failed = false;
        if (testCaseInfos.isEmpty()) {
            return;
        }
        for (TestCaseInfo testCaseInfo : testCaseInfos) {
            if (testCaseInfo.isSuccess()) {
                out.passed = true;
                continue;
            }
            out.failed = true;
        }
    }

    static class EntryImpl
    implements ILineCoverageModel.Entry {
        private final FullElementInfo elementInfo;
        private final Set<TestCaseInfo> testCaseInfos;

        public EntryImpl(FullElementInfo elementInfo, Set<TestCaseInfo> testCaseInfos) {
            this.elementInfo = elementInfo;
            this.testCaseInfos = testCaseInfos;
        }

        @Override
        public FullElementInfo getElementInfo() {
            return this.elementInfo;
        }

        @Override
        public Set<TestCaseInfo> getTestCaseInfos() {
            return this.testCaseInfos;
        }
    }

    private static class TestStatus {
        public boolean passed;
        public boolean failed;

        private TestStatus() {
        }
    }
}

