/*
 * Decompiled with CFR 0.152.
 */
package org.openclover.eclipse.core.ui.editors.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.services.IDisposable;
import org.eclipse.ui.texteditor.ITextEditor;
import org.openclover.eclipse.core.CloverPlugin;
import org.openclover.eclipse.core.SystemJob;
import org.openclover.eclipse.core.ui.editors.java.AnnotationDisplayListener;
import org.openclover.eclipse.core.ui.editors.java.CoverageAnnotationModel;
import org.openclover.util.Lists;

public class EditorCoverageSynchronizer
implements IWindowListener,
IPartListener2,
IDisposable {
    private IWorkbench workbench;
    private final List<AnnotationDisplayListener> annotationDisplayListeners;
    private volatile boolean started;

    public EditorCoverageSynchronizer(IWorkbench workbench) {
        this.workbench = workbench;
        this.annotationDisplayListeners = Lists.newArrayList();
        this.started = false;
        for (IWorkbenchWindow window : workbench.getWorkbenchWindows()) {
            window.getPartService().addPartListener((IPartListener2)this);
        }
        workbench.addWindowListener((IWindowListener)this);
    }

    public void syncWithCoverageSetting(int setting) {
        if (setting == 2 && this.started) {
            this.stop();
        } else if (setting != 2 && !this.started) {
            this.start(setting);
        } else {
            this.fireAnnotationDisplayChanged();
        }
    }

    private void start(int representationStyle) {
        if (!this.started && representationStyle != 2) {
            IWorkbenchWindow[] windows;
            this.started = true;
            for (IWorkbenchWindow window : windows = this.workbench.getWorkbenchWindows()) {
                IWorkbenchPage[] pages;
                for (IWorkbenchPage page : pages = window.getPages()) {
                    IEditorReference[] editors;
                    for (IEditorReference editor : editors = page.getEditorReferences()) {
                        this.applyAnnotations(editor.getPart(false));
                    }
                }
            }
        }
    }

    private void stop() {
        SystemJob stopJob = new SystemJob("Removing coverage annotations"){

            protected IStatus run(IProgressMonitor monitor) {
                IWorkbenchWindow[] windows;
                for (IWorkbenchWindow window : windows = EditorCoverageSynchronizer.this.workbench.getWorkbenchWindows()) {
                    IWorkbenchPage[] pages;
                    for (IWorkbenchPage page : pages = window.getPages()) {
                        IEditorReference[] editors;
                        for (IEditorReference editor : editors = page.getEditorReferences()) {
                            EditorCoverageSynchronizer.this.removeAnnotations(editor.getPart(false), true);
                        }
                    }
                }
                EditorCoverageSynchronizer.this.started = false;
                return Status.OK_STATUS;
            }
        };
        stopJob.schedule();
        try {
            stopJob.join();
        }
        catch (InterruptedException e) {
            CloverPlugin.logError("Failed to join on coverage synchronizer shutdown job", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnnotationDisplayListener(AnnotationDisplayListener listener) {
        List<AnnotationDisplayListener> list = this.annotationDisplayListeners;
        synchronized (list) {
            this.annotationDisplayListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAnnotationDisplayListener(AnnotationDisplayListener listener) {
        List<AnnotationDisplayListener> list = this.annotationDisplayListeners;
        synchronized (list) {
            this.annotationDisplayListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireAnnotationDisplayChanged() {
        ArrayList<AnnotationDisplayListener> listeners;
        List<AnnotationDisplayListener> list = this.annotationDisplayListeners;
        synchronized (list) {
            listeners = Lists.newArrayList(this.annotationDisplayListeners);
        }
        for (AnnotationDisplayListener listener : listeners) {
            listener.displayOptionChanged();
        }
    }

    public void dispose() {
        IWorkbenchWindow[] windows;
        if (this.started) {
            this.stop();
        }
        this.workbench.removeWindowListener((IWindowListener)this);
        for (IWorkbenchWindow window : windows = this.workbench.getWorkbenchWindows()) {
            window.getPartService().removePartListener((IPartListener2)this);
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        window.getPartService().removePartListener((IPartListener2)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        window.getPartService().addPartListener((IPartListener2)this);
    }

    public void partOpened(IWorkbenchPartReference partReference) {
        if (this.started) {
            this.applyAnnotations(partReference.getPart(false));
        }
    }

    public void partClosed(IWorkbenchPartReference partReference) {
        if (this.started) {
            this.removeAnnotations(partReference.getPart(false), true);
        }
    }

    private void applyAnnotations(IWorkbenchPart part) {
        if (this.isJavaEditor(part)) {
            CoverageAnnotationModel.applyTo((ITextEditor)part, this);
        }
    }

    private void removeAnnotations(IWorkbenchPart part, boolean async) {
        if (this.isJavaEditor(part)) {
            CoverageAnnotationModel.removeFrom((ITextEditor)part, async);
        }
    }

    private boolean isJavaEditor(IWorkbenchPart part) {
        return part instanceof ITextEditor && part.getTitle().toLowerCase().contains(".java");
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void partActivated(IWorkbenchPartReference partReference) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partReference) {
    }

    public void partDeactivated(IWorkbenchPartReference partReference) {
    }

    public void partHidden(IWorkbenchPartReference partReference) {
    }

    public void partVisible(IWorkbenchPartReference partReference) {
    }

    public void partInputChanged(IWorkbenchPartReference partReference) {
    }
}

